% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is.fitted.graph.R
\docType{class}
\name{fitted.graph-class}
\alias{fitted.graph-class}
\alias{fitted.graph}
\title{S4 class to represent a population tree or admixture graph and its underlying fitted parameter.}
\description{
S4 class to represent a population tree or admixture graph and its underlying fitted parameter.
}
\details{
The dot.graph element allows to plot the graph using grViz() from the DiagrammeR package or with the dot program after writing the files (e.g., dot -Tpng inputgraph.dot in terminal). Note that the dot file may be customized (e.g., to change leave color, parameter names...).
}
\section{Slots}{

\describe{
\item{\code{graph}}{The graph in 3 column format originated from the fitted graph.params object}

\item{\code{dot.graph}}{The fitted graph in dot format}

\item{\code{score}}{the score of the model (squared Mahalanobis distance between the observed and fitted basis F-statistics vectors)}

\item{\code{bic}}{The Bayesian Information Criterion associated to the model}

\item{\code{fitted.outstats}}{a matrix containing the target values of the fstats, the fitted values and the Z-score measuring the deviation of the fitted values from the target values in units of standard errors (i.e., Z=(fitted.value-target.value)/se(target.value))}

\item{\code{edges.length}}{a vector containing the estimated edges.length. Note finally, that the (two) edges coming from the roots are assumed of equal length (i.e., unrooted branch) as these are non-identifiable by the method.}

\item{\code{edges.length.scaled}}{If drift.scaling=TRUE, the estimated edges.length in units of t/2N}

\item{\code{edges.length.ci}}{A matrix with two columns (or four columns if drift scaled lengths are computed) containing for each edge length (in a row) the 95\% CI lower and higher bounds (columns 3 and 4 containing 95\% CI lower and higher bounds of drift scaled lengths, if any)}

\item{\code{admix.prop}}{a vector containing the estimated admixture proportions (if any)}

\item{\code{admix.prop.ci}}{a matrix with two columns containing for each admixture proportion (in a row) the 95\% CI lower and higher bounds}

\item{\code{nodes.het}}{The estimated heterozygosities for all nodes (if available; see drift.scaling argument in fit.graph)}

\item{\code{fitted.f2.mat}}{the matrix of all the fitted F2 statistics (obtained from fitted admixture graph parameter values) from which all the fitted fstats can be derived.}

\item{\code{optim.results}}{list containing results of the optim call}
}}

\seealso{
To generate fitted.graph object, see \code{\link{fit.graph}}.
}
