% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DBI-connection-transaction.R
\name{DBI-connection-transaction}
\alias{DBI-connection-transaction}
\alias{dbBegin,Pool-method}
\alias{dbCommit,Pool-method}
\alias{dbRollback,Pool-method}
\alias{dbWithTransaction,Pool-method}
\title{DBIConnection transaction methods are not supported for
Pool objects.}
\usage{
\S4method{dbBegin}{Pool}(conn, ...)

\S4method{dbCommit}{Pool}(conn, ...)

\S4method{dbRollback}{Pool}(conn, ...)

\S4method{dbWithTransaction}{Pool}(conn, code)
}
\arguments{
\item{conn, ..., code}{See \code{\link[DBI:transactions]{DBI::transactions()}}.}
}
\description{
You cannot perform SQL transaction using a Pool object directly
(because that would imply keeping a connection open and not
knowing when to return it back to the pool).
}
\details{
If you must use these methods, fetch an actual connection first
with \code{conn <- poolCheckout(pool)} -- then call the appropriate
DBI method on \code{conn}. Since you're fetching a connection
from the pool yourself, you must also remember to return it
back to the pool when you're done: \code{poolReturn(conn)}
(otherwise, you have a leaked connection).

For simple transactions, consider using
\code{\link[=poolWithTransaction]{poolWithTransaction()}} instead,
which is safer since it does not require you to fetch and
release the connection yourself.

See \code{\link[DBI:transactions]{DBI::transactions()}} for the original
documentation.
}
