% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gompertz.R
\docType{data}
\name{gompertz}
\alias{gompertz}
\title{Gompertz model with log-normal observations.}
\usage{
gompertz(
  K = 1,
  r = 0.1,
  sigma = 0.1,
  tau = 0.1,
  X_0 = 1,
  times = 1:100,
  t0 = 0,
  seed = 299438676L
)
}
\arguments{
\item{K}{carrying capacity}

\item{r}{growth rate}

\item{sigma}{process noise intensity}

\item{tau}{measurement error s.d.}

\item{X_0}{value of the latent state variable \code{X} at the zero time}

\item{times}{observation times}

\item{t0}{zero time}

\item{seed}{seed of the random number generator}
}
\value{
A \sQuote{pomp} object with simulated data.
}
\description{
\code{gompertz()} constructs a \sQuote{pomp} object encoding a stochastic Gompertz population model with log-normal measurement error.
}
\details{
The state process is
\deqn{X_{t+1} = K^{1-S} X_{t}^S \epsilon_{t},}{X[t+1]=K^(1-S) X[t]^S eps[t],} where \eqn{S=e^{-r}}{S=e^{-r}}
and the \eqn{\epsilon_t}{eps[t]} are i.i.d. lognormal random deviates with
variance \eqn{\sigma^2}{sigma^2}.
The observed variables \eqn{Y_t} are distributed as
\deqn{Y_t\sim\mathrm{Lognormal}(\log{X_t},\tau).}{Y[t]~Lognormal(log(X[t]),tau).}
Parameters include the per-capita growth rate \eqn{r}, the carrying
capacity \eqn{K}, the process noise s.d. \eqn{\sigma}{sigma}, the
measurement error s.d. \eqn{\tau}{tau}, and the initial condition
\eqn{X_0}{X[0]}.  The \sQuote{pomp} object includes parameter
transformations that log-transform the parameters for estimation purposes.
}
\examples{

plot(gompertz())
plot(gompertz(K=2,r=0.01))

}
\seealso{
More examples provided with \pkg{pomp}: 
\code{\link{blowflies}},
\code{\link{childhood_disease_data}},
\code{\link{compartmental_models}},
\code{\link{dacca}()},
\code{\link{ebola}},
\code{\link{ou2}()},
\code{\link{pomp_examples}},
\code{\link{ricker}()},
\code{\link{rw2}()},
\code{\link{verhulst}()}
}
\concept{pomp examples}
\keyword{models}
