##' Parameter estimation algorithms for POMP models.
##'
##' \pkg{pomp} currently implements the following algorithms for estimating model parameters:
##' \itemize{
##' \item \link[=mif2]{iterated filtering (IF2)}
##' \item \link[=pmcmc]{particle Markov chain Monte Carlo (PMCMC)}
##' \item \link[=abc]{approximate Bayesian computation (ABC)}
##' \item \link[=probe matching]{probe-matching via synthetic likelihood}
##' \item \link{nonlinear forecasting}
##' \item \link[=spectrum matching]{power-spectrum matching}
##' \item \link[=bsmc2]{Liu-West Bayesian sequential Monte Carlo}
##' \item \link[=kalman]{Ensemble and ensemble-adjusted Kalman filters}
##' }
##'
##' Help pages detailing each estimation algorithm are provided.
##'
##' @name estimation algorithms
##' @rdname estimation_algorithms
##' @family estimation methods
##' @seealso \link[=basic components]{basic model components},
##' \link[=workhorses]{workhorse functions},
##' \link[=elementary algorithms]{elementary algorithms}.
##' 
NULL
