% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workhorses.R
\docType{methods}
\name{rmeasure}
\alias{rmeasure}
\alias{rmeasure,ANY-method}
\alias{rmeasure,missing-method}
\alias{rmeasure,pomp-method}
\title{rmeasure}
\usage{
\S4method{rmeasure}{pomp}(object, x, times, params, ...)
}
\arguments{
\item{object}{an object of class \sQuote{pomp}, or of a class that extends \sQuote{pomp}.
This will typically be the output of \code{pomp}, \code{simulate}, or one of the \pkg{pomp} inference algorithms.}

\item{x}{an array containing states of the unobserved process.
The dimensions of \code{x} are \code{nvars} x \code{nrep} x \code{ntimes},
where \code{nvars} is the number of state variables,
\code{nrep} is the number of replicates,
and \code{ntimes} is the length of \code{times}.
One can also pass \code{x} as a named numeric vector, which is equivalent to the \code{nrep=1}, \code{ntimes=1} case.}

\item{times}{a numeric vector (length \code{ntimes}) containing times.
These must be in non-decreasing order.}

\item{params}{a \code{npar} x \code{nrep} matrix of parameters.
Each column is treated as an independent parameter set, in correspondence with the corresponding column of \code{x}.}

\item{...}{additional arguments are ignored.}
}
\value{
\code{rmeasure} returns a rank-3 array of dimensions
\code{nobs} x \code{nrep} x \code{ntimes},
where \code{nobs} is the number of observed variables.
}
\description{
Sample from the measurement model distribution, given values of the latent states and the parameters.
}
\seealso{
Specification of the measurement-model simulator: \link{rmeasure specification}

More on \pkg{pomp} workhorse functions: 
\code{\link{dmeasure}()},
\code{\link{dprior}()},
\code{\link{dprocess}()},
\code{\link{emeasure}()},
\code{\link{flow}()},
\code{\link{partrans}()},
\code{\link{pomp-package}},
\code{\link{rinit}()},
\code{\link{rprior}()},
\code{\link{rprocess}()},
\code{\link{skeleton}()},
\code{\link{vmeasure}()},
\code{\link{workhorses}}
}
\concept{extending the pomp package}
\concept{low-level interface}
\concept{pomp workhorses}
