% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workhorses.R
\docType{methods}
\name{rprior}
\alias{rprior}
\alias{rprior,ANY-method}
\alias{rprior,missing-method}
\alias{rprior,pomp-method}
\title{rprior}
\usage{
\S4method{rprior}{pomp}(object, params, ...)
}
\arguments{
\item{object}{an object of class \sQuote{pomp}, or of a class that extends \sQuote{pomp}.
This will typically be the output of \code{pomp}, \code{simulate}, or one of the \pkg{pomp} inference algorithms.}

\item{params}{a \code{npar} x \code{nrep} matrix of parameters.
Each column is treated as an independent parameter set, in correspondence with the corresponding column of \code{x}.}

\item{...}{additional arguments are ignored.}
}
\value{
A numeric matrix containing the required samples.
}
\description{
Sample from the prior probability distribution.
}
\seealso{
Specification of the prior distribution simulator: \link{prior specification}

More on \pkg{pomp} workhorse functions: 
\code{\link{dmeasure}()},
\code{\link{dprior}()},
\code{\link{dprocess}()},
\code{\link{flow}()},
\code{\link{partrans}()},
\code{\link{pomp-package}},
\code{\link{rinit}()},
\code{\link{rmeasure}()},
\code{\link{rprocess}()},
\code{\link{skeleton}()},
\code{\link{workhorses}}

More on Bayesian methods:
\code{\link{approximate Bayesian computation}},
\code{\link{bsmc2}()},
\code{\link{dprior}()},
\code{\link{pmcmc}()},
\code{\link{prior specification}}
}
\concept{Bayesian methods}
\concept{pomp workhorses}
