% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/skeleton_spec.R
\docType{methods}
\name{skeleton_spec}
\alias{skeleton_spec}
\alias{vectorfield}
\alias{map}
\title{The deterministic skeleton of a model}
\usage{
vectorfield(f)

map(f, delta.t = 1)
}
\arguments{
\item{f}{procedure for evaluating the deterministic skeleton
This can be a C snippet, an \R function, or the name of a native routine in a dynamically linked library.}

\item{delta.t}{positive numerical value; the size of the discrete time step corresponding to an application of the map}
}
\description{
Specification of \dfn{skeleton}.
}
\details{
The skeleton is a dynamical system that expresses the central tendency of the unobserved Markov state process.
As such, it is not uniquely defined, but can be both interesting in itself and useful in practice.
In \pkg{pomp}, the skeleton is used by \code{\link{trajectory}} and \code{\link{traj.match}}.
If the state process is a discrete-time stochastic process, then the skeleton is a discrete-time map.
To specify it, provide \preformatted{
  skeleton = map(f, delta.t)}
to \code{pomp}, where \code{f} implements the map and \code{delta.t} is the size of the timestep covered at one map iteration.
If the state process is a continuous-time stochastic process, then the skeleton is a vectorfield (i.e., a system of ordinary differential equations).
To specify it, supply \preformatted{
  skeleton = vectorfield(f)}
to \code{pomp}, where \code{f} implements the vectorfield, i.e., the right-hand-size of the differential equations.
In either case, \code{f} can be furnished either as a C snippet (the preferred choice), or an \R function.
In writing a \code{skeleton} C snippet, be aware that:
\enumerate{
  \item For each state variable, there is a corresponding component of the deterministic skeleton.
  The goal of such a snippet is to compute all the components.
  \item When the skeleton is a map, the component corresponding to state variable \code{x} is named \code{Dx} and is the new value of \code{x} after one iteration of the map.
  \item When the skeleton is a vectorfield, the component corresponding to state variable \code{x} is named \code{Dx} and is the value of \eqn{dx/dt}.
  \item As with the other C snippets, all states, parameters and covariates, as well as the current time, \code{t}, will be defined in the context within which the snippet is executed.
}
The tutorials on the \href{https://kingaa.github.io/pomp/}{package website} give some examples.
If \code{f} is an \R function, its arguments should be taken from among the state variables, parameters, covariates, and time.
It must also take the argument \sQuote{\code{...}}.
As with the other basic components, \code{f} may take additional arguments, provided these are passed along with it in the call to \code{pomp}.
The function \code{f} must return a numeric vector of the same length as the number of state variables, which contains the value of the map or vectorfield at the required point and time.
}
\section{Default behavior}{

The default \code{skeleton} is undefined.
It will yield missing values (\code{NA}) for all state variables.
}

\seealso{
Other information on model implementation: \code{\link{Csnippet}},
  \code{\link{accumulators}},
  \code{\link{covariate_table}},
  \code{\link{distributions}}, \code{\link{dmeasure_spec}},
  \code{\link{dprocess_spec}},
  \code{\link{parameter_trans}},
  \code{\link{pomp-package}}, \code{\link{prior_spec}},
  \code{\link{rinit_spec}}, \code{\link{rmeasure_spec}},
  \code{\link{rprocess_spec}},
  \code{\link{transformations}}, \code{\link{userdata}}
}
\concept{information on model implementation}
