\name{simulate-pomp}
\docType{methods}
\alias{simulate,pomp-method}
\alias{simulate-pomp}
\title{Running simulations of a partially-observed Markov process}
\description{\code{simulate} can be used to generate simulated data sets
  and/or to simulate the state process.}
\usage{
\S4method{simulate}{pomp}(object, nsim = 1, seed = NULL, xstart, params,
         states = FALSE, obs = FALSE, times = c(object@t0,time(object)),
         \dots)
}
\arguments{
  \item{object}{An object of class \code{pomp}.}
  \item{nsim}{The number of simulations to perform.  Note that the
    number of replicates will be \code{nsim} times
    \code{ncol(xstart)}.}
  \item{seed}{The random seed to use.}
  \item{xstart}{The initial conditions.}
  \item{params}{The parameters to use in simulating the model.}
  \item{states}{Do we want the state trajectories?}
  \item{obs}{Do we want data-frames of the simulated observations?}
  \item{times}{The times for which observations are required.  Note
    that the first element in \code{times} is the start time.  No
    observation will be returned for this time.}
  \item{\dots}{further arguments that are at present ignored.}
}
\value{
  If \code{states=FALSE} and \code{obs=FALSE} (the default), a list of
  \code{nsim} `pomp' objects is returned.  Each has a simulated data
  set.

  If \code{states=TRUE} and \code{obs=FALSE}, simulated state
  trajectories are returned as a rank-4 array with dimensions
  \code{nvar} x \code{ncol(xstart)} x \code{nsim} x \code{ntimes}.
  Here, \code{nvar} is the number of state variables and \code{ntimes}
  the length of the argument \code{times}.  The measurement process is
  not simulated in this case.   

  If \code{states=FALSE} and \code{obs=TRUE}, simulated observations are
  returned as a rank-4 array with dimensions \code{nobs} x
  \code{ncol(xstart)} x \code{nsim} x \code{(ntimes-1)}.  Here,
  \code{nobs} is the number of observables.

  If both \code{states=TRUE} and \code{obs=TRUE}, then a
  named list is returned.  It contains the state trajectories and
  simulated observations as above.
}
\details{
  Simulation of the state process and of the measurement process are
  each accomplished by a single call to the user-supplied
  \code{rprocess} and \code{rmeasure} functions, respectively.  This
  makes it possible for the user to write highly optimized code for
  these potentially expensive computations.
}
\references{}
\author{Aaron A. King (kingaa at umich dot edu)}
\seealso{\link{pomp-class}}
\keyword{models}
\keyword{ts}
