% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polyqtlR_functions.R
\name{BLUE}
\alias{BLUE}
\title{Calculate Best Linear Unbiased Estimates using linear mixed model from \code{nlme} package}
\usage{
BLUE(data, model, random, genotype.ID)
}
\arguments{
\item{data}{Data frame of genotype codes and corresponding phenotypes}

\item{model}{The model specification of fixed terms, eg. Yield ~ Clones}

\item{random}{The random component of the model (repeat structure, can be nested), eg. ~1 | Blocks if only Blocks are used}

\item{genotype.ID}{The colname used to describe genotypes, e.g. "Clones"}
}
\value{
A data-frame with columns "geno" for the genotype names, and "blue" for the BLUEs.
}
\description{
Calculation of BLUEs from data frame of genotype names and phenotypes (assuming repeated measurements)
}
\examples{
data("Phenotypes_4x")
blue <- BLUE(data = Phenotypes_4x,model = pheno~geno,random = ~1|year,genotype.ID = "geno")
}
