% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bwd.R
\name{bw_cv_polysph}
\alias{bw_cv_polysph}
\title{Cross-validation bandwidth selection for polyspherical kernel
density estimator}
\usage{
bw_cv_polysph(X, d, kernel = 1, kernel_type = 1, k = 10,
  intrinsic = FALSE, type = c("LCV", "LSCV")[1], M = 10000, bw0 = NULL,
  na.rm = FALSE, h_min = 0, upscale = FALSE, deriv = 0,
  imp_mc = TRUE, seed_mc = NULL, exact_vmf = FALSE, common_h = FALSE,
  spline = FALSE, opt = c("optim", "nlm")[1], ncores = 1, ...)
}
\arguments{
\item{X}{a matrix of size \code{c(n, sum(d) + r)} with the sample.}

\item{d}{vector of size \code{r} with dimensions.}

\item{kernel}{kernel employed: \code{1} for von Mises--Fisher (default);
\code{2} for Epanechnikov; \code{3} for softplus.}

\item{kernel_type}{type of kernel employed: \code{1} for product kernel
(default); \code{2} for spherically symmetric kernel.}

\item{k}{softplus kernel parameter. Defaults to \code{10.0}.}

\item{intrinsic}{use the intrinsic distance, instead of the
extrinsic-chordal distance, in the kernel? Defaults to \code{FALSE}.}

\item{type}{cross-validation type, either \code{"LCV"} (default) or
\code{"LSCV"}.}

\item{M}{Monte Carlo samples to use for approximating the integral in
the LSCV loss.}

\item{bw0}{initial bandwidth vector for minimizing the CV loss. If
\code{NULL}, it is computed internally by magnifying the
\code{\link{bw_rot_polysph}} bandwidths by 50\%. Can be also a matrix of
initial bandwidth vectors.}

\item{na.rm}{remove \code{NA}s in the objective function? Defaults to
\code{FALSE}.}

\item{h_min}{minimum h enforced (componentwise). Defaults to \code{0}.}

\item{upscale}{rescale the resulting bandwidths to work for derivative
estimation? Defaults to \code{FALSE}.}

\item{deriv}{derivative order to perform the upscaling. Defaults to \code{0}.}

\item{imp_mc}{use importance sampling in the Monte Carlo approximation of
the integral in the LSCV loss? It is more accurate but also more time
consuming. Defaults to \code{TRUE}.}

\item{seed_mc}{seed for the Monte Carlo simulations used to estimate the
integral in the LSCV loss. Defaults to \code{NULL} (no seed is fixed for
different bandwidths).}

\item{exact_vmf}{use the closed-form for the LSCV loss with the
von Mises--Fisher kernel? Defaults to \code{FALSE}.}

\item{common_h}{use the same bandwidth for all dimensions? Defaults to
\code{FALSE}.}

\item{spline}{use a faster spline approximation to compute Bessel functions?
Defaults to \code{FALSE}.}

\item{opt}{optimizer to use; either \code{"\link{optim}"} (default) or
\code{"\link{nlm}"}.}

\item{ncores}{number of cores used during the optimization. Defaults to
\code{1}.}

\item{...}{further arguments passed to \code{\link{optim}} or
\code{\link{nlm}} (if \code{ncores = 1}) or
\code{\link[optimParallel]{optimParallel}} (if \code{ncores > 1}).}
}
\value{
A list with entries \code{bw} (optimal bandwidth) and \code{opt},
the latter containing the output of \code{\link[stats]{nlm}},
\code{\link[stats]{optim}}, or \code{\link[optimParallel]{optimParallel}}.
}
\description{
Likelihood Cross-Validation (LCV) and Least Squares
Cross-Validation (LSCV) bandwidth selection for the polyspherical kernel
density estimator.
}
\details{
If \code{bw0} is a matrix, then the optimization is started at that
row of bandwidths that is most promising for the optimization, i.e., the
bandwidths that minimized the CV loss.
}
\examples{
n <- 20
d <- 1:2
kappa <- rep(10, 2)
X <- r_vmf_polysph(n = n, d = d, mu = r_unif_polysph(n = 1, d = d),
                   kappa = kappa)
bw_cv_polysph(X = X, d = d, type = "LCV")$bw
bw_cv_polysph(X = X, d = d, type = "LSCV", exact_vmf = TRUE)$bw
}
