% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method_proper.R
\name{is.proper}
\alias{is.proper}
\alias{is.column.proper}
\alias{is.row.proper}
\title{Proper polynomial matrices}
\usage{
is.proper(pm)

is.column.proper(pm)

is.row.proper(pm)
}
\arguments{
\item{pm}{a polyMatrix objects}
}
\value{
True if object \code{pm} is a (row-/column-) proper matrix
}
\description{
Tests the proper property of polynomial matrix.
A polynomial matrix is proper if the associeted matrix has a full rank.
}
\details{
Polynomial matrix is column (row, full) proper (or reduced) if associated matrix has same rank
as the number of column (row)
}
\section{Functions}{
\itemize{
\item \code{is.column.proper}: tests if its argument is a column-proper matrix

\item \code{is.row.proper}: tests if its argument is a row-proper matrix
}}

\examples{
  pm <- parse.polyMatrix(
    "-1 + 7x     , x",
    " 3 - x + x^2, -1 + x^2 - 3 x^3"
  )
  is.column.proper(pm)
  is.row.proper(pm)
  is.proper(pm)

}
