% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/policy_data.R, R/policy_data_functions.R
\name{policy_data}
\alias{policy_data}
\alias{print.policy_data}
\title{Create Policy Data Object}
\usage{
policy_data(
  data,
  baseline_data,
  type = "wide",
  action,
  covariates,
  utility,
  baseline = NULL,
  deterministic_rewards = NULL,
  id = NULL,
  stage = NULL,
  event = NULL,
  verbose = FALSE
)

\method{print}{policy_data}(x, digits = 2, ...)
}
\arguments{
\item{data}{\link{data.frame} or \link{data.table}; see Examples.}

\item{baseline_data}{\link{data.frame} or \link{data.table}; see Examples.}

\item{type}{Character string. If "wide", \code{data} is considered to be on wide format.
If "long", \code{data} is considered to be on long format; see Examples.}

\item{action}{Action variable name(s). Character vector or character string.
\itemize{
\item{} A vector is valid for wide data. The length of the vector determines the number of stages (K).
\item{} A string is valid for single stage wide data or long data.
}}

\item{covariates}{Stage specific covariate name(s). Character vector or named list of character vectors.
\itemize{
\item{} A vector is valid for single stage wide data or long data.
\item{} A named list is valid for multiple stage wide data. Each element must be a character vector with length K.
}}

\item{utility}{Utility/Reward variable name(s). Character string or vector.
\itemize{
\item{} A string is valid for long data and wide data with a single final utility.
\item{} A vector is valid for wide data with incremental rewards. Must have length K+1; see Examples.
}}

\item{baseline}{Baseline covariate name(s). Character vector.}

\item{deterministic_rewards}{Deterministic reward variable name(s). Named list of character vectors of length K.
The name of each element must be on the form "U_Aa" where "a" corresponds to an action in the action set.}

\item{id}{ID variable name. Character string.}

\item{stage}{Stage number variable name.}

\item{event}{Event indicator name.}

\item{verbose}{Logical. If TRUE, formatting comments are printed to the console.}

\item{x}{Object to be printed.}

\item{digits}{Minimum number of digits to be printed.}

\item{...}{Additional arguments passed to print.}
}
\value{
\code{policy_data()} returns an object of class "policy_data".
The object is a list containing the following elements:
\item{\code{stage_data}}{\link{data.table} containing the id, stage number, event
indicator, action (\eqn{A_k}), state covariates
(\eqn{X_k}), reward (\eqn{U_k}), and the
deterministic rewards.}
\item{\code{baseline_data}}{\link{data.table} containing the id and baseline
covariates (\eqn{B}).}
\item{\code{colnames}}{List containing the state covariate names, baseline
covariate names, and the deterministic reward variable
names.}
\item{\code{action_set}}{Sorted character vector describing the action set, i.e.,
the possible actions at each stage.}
\item{\code{dim}}{List containing the number of observations (n) and the
number of stages (K).}
}
\description{
\code{policy_data()} creates a policy data object which
is used as input to \code{\link[=policy_eval]{policy_eval()}} and \code{\link[=policy_learn]{policy_learn()}} for policy
evaluation and data adaptive policy learning.
}
\details{
Each observation has the sequential form
\deqn{O= {B, U_1, X_1, A_1, ..., U_K, X_K, A_K, U_{K+1}},}
for a possibly stochastic number of stages K.
\itemize{
\item{} \eqn{B} is a vector of baseline covariates.
\item{} \eqn{U_k} is the reward at stage k (not influenced by the action \eqn{A_k}).
\item{} \eqn{X_k} is a vector of state covariates summarizing the state at stage k.
\item{} \eqn{A_k} is the categorical action at stage k.
}
The utility is given by the sum of the rewards, i.e.,
\eqn{U = \sum_{k = 1}^{K+1} U_k}.
}
\section{S3 generics}{

The following S3 generic functions are available for an object of
class \code{policy_data}:
\itemize{
\item{\code{\link[=partial]{partial()}}}{ Trim the maximum number
of stages in a \code{policy_data} object.}
\item{\code{\link[=subset.policy_data]{subset.policy_data()}}}{ Subset a a \code{policy_data} object on ID.}
\item{\code{\link[=get_history]{get_history()}}}{ Summarize the history and action at
a given stage.}
\item{\code{\link[=get_history_names]{get_history_names()}}}{ Get history variable names.}
\item{\code{\link[=get_actions]{get_actions()}}}{ Get the action at every stage.}
\item{\code{\link[=get_utility]{get_utility()}}}{Get the utility.}
}
}

\examples{
library("polle")
### Single stage: Wide data
source(system.file("sim", "single_stage.R", package="polle"))
d1 <- sim_single_stage(5e2, seed=1)
head(d1, 5)
# constructing policy_data object:
pd1 <- policy_data(d1,
                   action="A",
                   covariates=c("Z", "B", "L"),
                   utility="U")
pd1
# associated S3 methods:
methods(class = "policy_data")
head(get_actions(pd1), 5)
head(get_utility(pd1), 5)
head(get_history(pd1)$H, 5)

### Two stage: Wide data
source(system.file("sim", "two_stage.R", package="polle"))
d2 <- sim_two_stage(5e2, seed=1)
head(d2, 5)
# constructing policy_data object:
pd2 <- policy_data(d2,
                  action = c("A_1", "A_2"),
                  baseline = c("B"),
                  covariates = list(L = c("L_1", "L_2"),
                                    C = c("C_1", "C_2")),
                  utility = c("U_1", "U_2", "U_3"))
pd2
head(get_history(pd2, stage = 2)$H, 5) # state/Markov type history and action, (H_k,A_k).
head(get_history(pd2, stage = 2, full_history = TRUE)$H, 5) # Full history and action, (H_k,A_k).

### Multiple stages: Long data
source(system.file("sim", "multi_stage.R", package="polle"))
d3 <- sim_multi_stage(5e2, seed = 1)
head(d3$stage_data, 10)
# constructing policy_data object:
pd3 <- policy_data(data = d3$stage_data,
                   baseline_data = d3$baseline_data,
                   type = "long",
                   id = "id",
                   stage = "stage",
                   event = "event",
                   action = "A",
                   utility = "U")
pd3
head(get_history(pd3, stage = 3)$H, 5) # state/Markov type history and action, (H_k,A_k).
head(get_history(pd3, stage = 2, full_history = TRUE)$H, 5) # Full history and action, (H_k,A_k).
}
\seealso{
\code{\link[=policy_eval]{policy_eval()}}, \code{\link[=policy_learn]{policy_learn()}}, \code{\link[=copy_policy_data]{copy_policy_data()}}
}
