% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/global_sessions_config.R
\name{global_sessions_config}
\alias{global_sessions_config}
\title{Configuration for global sessions}
\usage{
global_sessions_config(
  app_name,
  api_key,
  firebase_config = NULL,
  admin_mode = FALSE,
  is_invite_required = TRUE,
  sign_in_providers = "email",
  is_email_verification_required = TRUE,
  is_auth_required = TRUE,
  sentry_dsn = NULL,
  cookie_expires = 365L
)
}
\arguments{
\item{app_name}{the name of the app.}

\item{api_key}{the API key. Either from \url{https://polished.tech} or your on premise \code{polished} API
deployment.}

\item{firebase_config}{a list containing your Firebase project configuration.  This list should have the
following named elements:
\itemize{
\item{\code{apiKey}}
\item{\code{authDomain}}
\item{\code{projectId}}
}}

\item{admin_mode}{\code{FALSE} by default.  Set to \code{TRUE} to enter the \code{polished} Admin Panel without needing
to register and sign in.  This is useful during development for inviting the first users to your app.
Make sure to set \code{admin_mode = FALSE} before deploying your app.}

\item{is_invite_required}{\code{TRUE} by default.  Whether or not to require the user to have an
invite before registering/signing in}

\item{sign_in_providers}{the sign in providers to enable.  Valid values are \code{"google"}
\code{"email"}, \code{"microsoft"}, and/or \code{"facebook"}. Defaults to \code{"email"}.}

\item{is_email_verification_required}{\code{TRUE} by default.  Whether or not to require the user to
verify their email before accessing your Shiny app.}

\item{is_auth_required}{\code{TRUE} by default.  Whether or not to require users to be signed
in to access the app.  It can be useful to set this argument to \code{FALSE} if you want to
allow user to do certain actions (such as viewing charts and tables) without signing in,
and only require users to sign in if they want to save data to your database.}

\item{sentry_dsn}{either \code{NULL}, the default, or your Sentry project DSN.}

\item{cookie_expires}{the number of days before a user's cookie expires.
Set to \code{NULL} to force Sign Out at session end. This argument is passed to
the \code{expires} option in js-cookie: \url{https://github.com/js-cookie/js-cookie#expires}.
Default value is \code{365} (i.e. 1 year)}
}
\description{
This is the primary function for configuring \code{polished}.  It configures your app's instance of the
\code{Sessions} class that manages your user's \code{polished} sessions.  Call this function in
your \code{global.R} file.  See \url{https://github.com/Tychobra/polished/blob/master/inst/examples/polished_example_01/global.R}
for a complete example.
}
\examples{

\dontrun{
# global.R

global_sessions_config(
  app_name = "<your app name>",
  api_key = "<your API key>"
)

}

}
