% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/poismf.R
\name{poismf_unsafe}
\alias{poismf_unsafe}
\title{Poisson factorization with no input casting}
\usage{
poismf_unsafe(A, B, Xcsr, Xcsc, k, ...)
}
\arguments{
\item{A}{Initial values for the user-factor matrix of dimensions [dimA, k],
assuming row-major order. Can be passed as a vector of dimension [dimA*k], or
as a matrix of dimension [k, dimA]. Note that R matrices use column-major order,
so if you want to pass an R matrix as initial values, you'll need to transpose it,
hence the shape [k, dimA]. Recommended to initialize `~ Gamma(1,1)`.
\bold{Will be modified in-place}.}

\item{B}{Initial values for the item-factor matrix of dimensions [dimB, k]. See
documentation about `A` for more details.}

\item{Xcsr}{The \bold{transpose} of the `X` matrix in CSC format (so that its structure
would match a CSR matrix). Should be an object of class `Matrix::dgCMatrix`.}

\item{Xcsc}{The `X` matrix in CSC format. Should be an object of class `Matrix::dgCMatrix`.}

\item{k}{The number of latent factors. \bold{Must match with the dimension of `A` and `B`}.}

\item{...}{Other hyperparameters that can be passed to `poismf`. See the documentation
for \link{poismf} for details about possible hyperparameters. Init type and seed are
ignored as the `A` and `B` matrices are supposed to be passed already-initialized.}
}
\value{
A `poismf` model object. See the documentation for \link{poismf} for details.
}
\description{
This is a faster version of \link{poismf} which will not make any checks
or castings on its inputs. It is intended as a fast alternative when a model is to
be fit multiple times with different hyperparameters, and for allowing
custom-initialized factor matrices. \bold{Note that since it doesn't make any checks
or conversions, passing the wrong kinds of inputs or passing inputs with mismatching
dimensions will crash the R process}.

For most use cases, it's recommended to use the function `poismf` instead.
}
\examples{
library(poismf)

### create a random sparse data frame in COO format
nrow <- 10^2 ## <- users
ncol <- 10^3 ## <- items
nnz  <- 10^4 ## <- events (agg)
set.seed(1)
X <- data.frame(
        row_ix = sample(nrow, size=nnz, replace=TRUE),
        col_ix = sample(ncol, size=nnz, replace=TRUE),
        count  = rpois(nnz, 1) + 1
     )
X <- X[!duplicated(X[, c("row_ix", "col_ix")]), ]

### convert to required format
Xcsr <- Matrix::sparseMatrix(
            i=X$col_ix, j=X$row_ix, x=X$count,
            giveCsparse=TRUE
)
Xcsc <- Matrix::sparseMatrix(
            i=X$row_ix, j=X$col_ix, x=X$count,
            giveCsparse=TRUE
)

### initialize factor matrices
k <- 5L
A <- rgamma(nrow*k, 1, 1)
B <- rgamma(ncol*k, 1, 1)

### call function
model <- poismf_unsafe(A, B, Xcsr, Xcsc, k)
}
\seealso{
\link{poismf}
}
