% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmpp_data.R
\name{pmpp_data}
\alias{pmpp_data}
\title{Transform a single variable in the matrix format into the long panel format}
\usage{
pmpp_data(indata, t_dim = "cols", var_name = "Y")
}
\arguments{
\item{indata}{matrix with  a single variable}

\item{t_dim}{character string, one of: 'cols', 'rows';
whether time dimension in indata is across columns or rows}

\item{var_name}{character string; name of the variable in indata}
}
\value{
A \code{data.frame} with 3 columns: unit, time and variable's values.
}
\description{
This function transforms a matrix of data with cross-sectional
             and time dimensions in rows and columns or columns and rows into
             a panel-structured, 3-column data frame
}
\examples{
set.seed(1)
matrix_var <- matrix(rnorm(100), nrow = 20)
panel_var <- pmpp_data(matrix_var)
}
\author{
Michal Oleszak
}
