% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_fns.R
\name{gtest_heatmap}
\alias{gtest_heatmap}
\title{Plot a heatmap for the g-test results of imd-anova}
\usage{
gtest_heatmap(
  volcano,
  pval_thresh,
  show_sig,
  interactive,
  color_low,
  color_high,
  plotly_layout,
  text_size,
  display_count,
  x_lab,
  y_lab,
  title_lab,
  legend_lab
)
}
\arguments{
\item{volcano}{`data.frame` produced by pmartR:::\link{make_volcano_plot_df}}

\item{pval_thresh}{numeric value indicating the p-value threshold for
significance.}

\item{show_sig}{Boolean whether to show the visual indicator that a certain
bin combination is significant by the g-test}

\item{interactive}{passed from
\code{\link[pmartR:plot.statRes]{pmartR::plot.statRes()}}. If T, will build
a plotly version of the plot.  Defaults to FALSE.}

\item{color_low}{character string specifying the color of the gradient for
low count values.}

\item{color_high}{character string specifying the color of the gradient for
high count values.}

\item{plotly_layout}{A list of arguments, not including the plot, to be
passed to plotly::layout if interactive = T.}

\item{text_size}{An integer specifying the size of the text (number of
non-missing values) within the plot. The default is 3.}

\item{display_count}{logical value. Indicates whether the non-missing counts
will be displayed on the bar plot. The default is TRUE.}

\item{x_lab}{character string specifying the x-axis label.}

\item{y_lab}{character string specifying the y-axis label.}

\item{title_lab}{character string specifying the plot title.}

\item{legend_lab}{character string specifying the legend title.}
}
\value{
`ggplot or plotly` object, depending on if \code{interactive} is set
to TRUE or FALSE respectively. A g-test heatmap
}
\description{
Plots a heatmap showing bins for combinations of # of biomolecules present
across groups.  Bins are colored by the number of biomolecules falling into
each bin, and have indicators for significance by g-test.
}
\keyword{internal}
