% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/client.R
\name{tableau_invoke}
\alias{tableau_invoke}
\title{Programatically invoke a Tableau extension function}
\usage{
tableau_invoke(pr, script, ..., .toJSON_args = NULL, .quiet = FALSE)
}
\arguments{
\item{pr}{Either a \link{tableau_extension} style Plumber router object, or, the
filename of a plumber.R that implements a Tableau extension.}

\item{script}{The script string that identifies the plumber route to invoke.
(Equivalent to the first argument to \code{SCRIPT_STR}, et al., in Tableau.) URL
query parameters are allowed.}

\item{...}{Zero or more unnamed arguments to be passed to the script.}

\item{.toJSON_args}{Additional options that should be passed to
\code{\link[jsonlite:fromJSON]{jsonlite::toJSON()}} when the \code{...} arguments are serialized; for example,
\code{pretty = TRUE} or \code{digits = 8}.}

\item{.quiet}{If \code{TRUE}, do not print response bodies when errors occur.}
}
\value{
The object that was returned from the request, JSON-decoded using
\code{jsonlite::parse_json}.
}
\description{
Simulates invoking a Tableau extension function from a Tableau calculated
field \verb{SCRIPT_*} call. Intended for unit testing of plumbertableau extensions.
}
\examples{
pr_path <- system.file("plumber/stringutils/plumber.R",
  package = "plumbertableau")

tableau_invoke(pr_path, "/lowercase", LETTERS[1:5])

}
