% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plu_ral.R
\name{plu_ral}
\alias{plu_ral}
\alias{ral}
\title{Pluralize a phrase based on the length of a vector}
\usage{
plu_ral(
  x,
  vector = integer(2),
  n_fn = NULL,
  ...,
  n = length(vector),
  pl = abs(n) != 1,
  irregulars = c("moderate", "conservative", "liberal", "none"),
  replace_n = TRUE
)

ral(
  x,
  vector = integer(2),
  n_fn = NULL,
  ...,
  n = length(vector),
  pl = abs(n) != 1,
  irregulars = c("moderate", "conservative", "liberal", "none"),
  replace_n = TRUE
)
}
\arguments{
\item{x}{An English word or phrase to be pluralized.
See details for special sequences which are handled differently.}

\item{vector}{A vector whose length determines \code{n}. Defaults to length 2.}

\item{n_fn}{A function to apply to the output of the special sequence
\code{"n"}. See examples.
Defaults to \code{identity}, which returns \code{n} unchanged.}

\item{...}{Additional arguments passed to the function \code{n_fn}.}

\item{n}{The number which will determine the plurality of \code{x}.
Defaults to \code{length(n)}. If specified, overrides \code{vector}.}

\item{pl}{A logical value indicating whether to use the plural form (if
\code{TRUE}) or the singular form (if \code{FALSE}) of \code{x}.
Defaults to \code{FALSE} when \code{n} is \code{1} or \code{-1} and \code{TRUE} for all other
values.
If specified, overrides \code{n}.}

\item{irregulars}{What level of irregularity to use in pluralization.
\code{"moderate"} uses the most common pluralization.
\code{"conservative"} uses the most common irregular plural if one exists,
even if a regular plural is more common.
\code{"liberal"} uses a regular plural if it exists, even if an irregular
plural is more common.
\code{"none"} attempts to apply regular noun pluralization rules to all words.
Defaults to \code{"moderate"}.
The default can be changed by setting \code{options(plu.irregulars)}.
See examples in \code{\link[=ralize]{ralize()}} for more details.}

\item{replace_n}{A logical indicating whether to use special handling for
\code{"n"}.
See details.
Defaults to \code{TRUE}.}
}
\value{
The character vector \code{x} altered to match the number of \code{n}
}
\description{
Pluralize a phrase based on the length of a vector
}
\details{
Certain strings in \code{x} are treated specially.
\itemize{
\item By default, \code{"a"} and \code{"an"} are deleted in the plural
("a word" to "words").
\item The string \code{"n"} will be replaced with the length of \code{vector} or the
number in \code{n}.
\itemize{
\item This output can be modified with \code{n_fn}.
}
\item Strings between braces separated by a pipe will be treated as a custom
plural (\code{"{a|some} word"} to "a word", "some words").
\itemize{
\item Three strings separated by pipes will be treated as a singular, dual,
and plural form (\code{"{the|both|all} word"} to "the word" (1),
"both words" (2), "all words" (3+)).
}
\item Any other string between braces will be treated as invariant
(\code{"attorney {general}"} to "attorneys general").
}
}
\examples{
plu::ral("apple", pl = FALSE)
plu::ral("apple", pl = TRUE)

plu::ral("apple", n = 1)
plu::ral("apple", n = 2)
plu::ral("apple", n = 0)
plu::ral("apple", n = -1)
plu::ral("apple", n = 0.5)

mon <- c("apple")
tue <- c("pear", "pear")

plu::ral("apple", mon)
plu::ral("pear", tue)

paste("Monday, the caterpillar ate", plu::ral("an apple", mon))
paste("Tuesday, the caterpillar ate", plu::ral("a pear", tue))

paste("Monday, the caterpillar visited", plu::ral("an {apple} tree", mon))
paste("Tuesday, the caterpillar visited", plu::ral("a {pear} tree", tue))

paste("Monday, the caterpillar ate", plu::ral("a {single|multiple} apple", mon))
paste("Tuesday, the caterpillar ate", plu::ral("a {single|multiple} pear", tue))

later <- c(
  rep("plum", 3), rep("strawberry", 4), rep("orange", 5),
  "chocolate cake", "ice-cream cone", "pickle", "Swiss cheese", "salami",
  "lollipop", "cherry pie", "sausage", "cupcake", "watermelon"
)

paste("The caterpillar ate", plu::ral("{the|both|all of the} apple", mon))
paste("The caterpillar ate", plu::ral("{the|both|all of the} pear", tue))
paste("The caterpillar ate", plu::ral("{the|both|all of the} delicacy", later))

paste("The caterpillar ate", plu::ral("n apple", mon))
paste("The caterpillar ate", plu::ral("n delicacy", later))

paste("The caterpillar ate", plu::ral("n apple", mon, nombre::cardinal))
paste("The caterpillar ate", plu::ral("n delicacy", later, nombre::cardinal))
}
\seealso{
\code{\link[=ralize]{ralize()}} to convert an English word to its plural form.
}
