% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plu_ralize.R
\name{plu_ralize}
\alias{plu_ralize}
\alias{ralize}
\title{Pluralize a word}
\source{
Irregular plurals list adapted from \href{https://github.com/en-wl/wordlist/tree/master/agid}{Automatically Generated Inflection Database (AGID)}

Copyright 2000-2014 by Kevin Atkinson

Permission to use, copy, modify, distribute and sell this database,
the associated scripts, the output created form the scripts and its
documentation for any purpose is hereby granted without fee,
provided that the above copyright notice appears in all copies and
that both that copyright notice and this permission notice appear in
supporting documentation. Kevin Atkinson makes no representations
about the suitability of this array for any purpose. It is provided
"as is" without express or implied warranty.
}
\usage{
plu_ralize(
  x,
  irregulars = getOption("plu.irregulars", c("moderate", "conservative", "liberal",
    "none", "easter"))
)

ralize(
  x,
  irregulars = getOption("plu.irregulars", c("moderate", "conservative", "liberal",
    "none", "easter"))
)
}
\arguments{
\item{x}{A character vector of English words to be pluralized}

\item{irregulars}{What level of irregularity to use in pluralization.
\code{"moderate"} uses the most common pluralization.
\code{"conservative"} uses the most common irregular plural if one exists,
even if a regular plural is more common.
\code{"liberal"} uses a regular plural if it exists, even if an irregular
plural is more common.
\code{"none"} attempts to apply regular noun pluralization rules to all words.
Defaults to \code{"moderate"}.
The default can be changed by setting \code{options(plu.irregulars)}.
See examples.}
}
\value{
The character vector \code{x} pluralized
}
\description{
Pluralize a word
}
\examples{
plu::ralize("word")
plu::ralize(c("group", "word"))

plu::ralize(c("formula", "person", "child"), irregulars = "conservative")
plu::ralize(c("formula", "person", "child"), irregulars = "moderate")
plu::ralize(c("formula", "person", "child"), irregulars = "liberal")
plu::ralize(c("formula", "person", "child"), irregulars = "none")
}
\seealso{
\code{\link[plu:ral]{plu::ral()}} to pluralize an English phrase based on a condition
}
