% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pls.R
\name{pls}
\alias{pls}
\alias{update.pls}
\title{General Interface for Partial Least Squares (PLS)}
\usage{
pls(mode = "unknown", predictor_prop = NULL, num_comp = NULL)

\method{update}{pls}(
  object,
  parameters = NULL,
  predictor_prop = NULL,
  num_comp = NULL,
  fresh = FALSE,
  ...
)
}
\arguments{
\item{mode}{A single character string for the type of model.
Possible values for this model are "unknown", "regression", or
"classification".}

\item{predictor_prop}{The maximum proportion of original predictors that can
have \emph{non-zero} coefficients for each PLS component (via regularization).
This value is used for all PLS components for X.}

\item{num_comp}{The number of PLS components to retain.}

\item{object}{A PLS model specification.}

\item{parameters}{A 1-row tibble or named list with \emph{main}
parameters to update. If the individual arguments are used,
these will supersede the values in \code{parameters}. Also, using
engine arguments in this object will result in an error.}

\item{fresh}{A logical for whether the arguments should be
modified in-place of or replaced wholesale.}

\item{...}{Not used for \code{update()}.}
}
\description{
\code{pls()} is a way to generate a \emph{specification} of a model before
fitting and allows the model to be created using R. The main
arguments for the
model are:
\itemize{
\item \code{predictor_prop}: The proportion of predictors that are allowed
to affect each PLS loading.
\item \code{num_comp}: The number of PLS components to retain.
}
These arguments are converted to their specific names at the
time that the model is fit. Other options and argument can be
set using \code{set_engine()}. If left to their defaults
here (\code{NULL}), the values are taken from the underlying model
functions. If parameters need to be modified, \code{update()} can be used
in lieu of recreating the object from scratch.
}
\details{
The model can be created using the \code{fit()} function using the
following \emph{engines}:
\itemize{
\item \pkg{R}:  \code{"mixOmics"}  (the default)
}
}
\section{Engine Details}{


Engines may have pre-set default arguments when executing the
model fit call. The possible model calls are shown in the Examples section
below.
}

\examples{
pls(num_comp = 2, predictor_prop = 0.2) \%>\%
  set_engine("mixOmics") \%>\%
  set_mode("regression") \%>\%
  translate()

pls(num_comp = 2, predictor_prop = 1) \%>\%
  set_engine("mixOmics") \%>\%
  set_mode("classification") \%>\%
  translate()

pls(num_comp = 6) \%>\%
  set_engine("mixOmics") \%>\%
  set_mode("regression") \%>\%
  translate()

pls() \%>\%
  set_engine("mixOmics") \%>\%
  set_mode("classification") \%>\%
  translate()


model <- pls(predictor_prop =  0.1)
model
update(model, predictor_prop = 1)
update(model, predictor_prop = 1, fresh = TRUE)
}
