% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bivarplots.r
\name{bivarplots}
\alias{bivarplots}
\title{Plots the bivariate relationship between two measures for each group/unit}
\usage{
bivarplots(x, y, group, data)
}
\arguments{
\item{x}{A vector.}

\item{y}{A vector.}

\item{group}{A vector.}

\item{data}{A data frame.}
}
\value{
A series of figures that plot the bivariate relationship between two measures for each group/unit.
}
\description{
Returns a plot of the bivariate relationship between two measures for each group/unit.
}
\examples{
a <- runif(1000, min = 0, max = 1)
b <- a + rnorm(1000, mean = 0, sd = 1)
c <- rep(c(1:10), times = 100)
data <- data.frame(a, b, c)
bivarplots("a", "b", "c", data)
}
\author{
Charles Crabtree \email{ccrabtr@umich.edu}
}
