% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/orca.R
\name{orca}
\alias{orca}
\title{Static image export via orca}
\usage{
orca(p, file = "plot.png", format = tools::file_ext(file), scale = NULL,
  width = NULL, height = NULL, mathjax = FALSE, parallel_limit = NULL,
  verbose = FALSE, debug = FALSE, safe = FALSE)
}
\arguments{
\item{p}{a plotly object.}

\item{file}{output filename.}

\item{format}{the output format (png, jpeg, webp, svg, pdf, eps).}

\item{scale}{Sets the image scale. Applies to all output images.}

\item{width}{Sets the image width. If not set, defaults to \code{layout.width} value.
Applies to all output images.}

\item{height}{Sets the image height. If not set, defaults to \code{layout.height} value.
Applies to all output images.}

\item{mathjax}{whether or not to include MathJax (required to render \link{TeX}).
If \code{TRUE}, the PLOTLY_MATHJAX_PATH environment variable must be set and point
to the location of MathJax (this variable is also used to render \link{TeX} in
interactive graphs, see \link{config}).}

\item{parallel_limit}{Sets the limit of parallel tasks run.}

\item{verbose}{Turn on verbose logging on stdout.}

\item{debug}{Starts app in debug mode and turn on verbose logs on stdout.}

\item{safe}{Turns on safe mode: where figures likely to make browser window
hang during image generating are skipped.}
}
\description{
The function makes a system call to the orca command-line utility,
see the installation instructions \href{https://github.com/plotly/orca#installation}{here}
}
\examples{

\dontrun{
p <- plot_ly(z = ~volcano) \%>\% add_surface()
orca(p, "surface-plot.svg")
}

}
\author{
Carson Sievert
}
