% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spathxy.R
\name{spathxy}
\alias{spathxy}
\title{Reordering Points to Form a "s" Shape}
\usage{
spathxy(
  x,
  y,
  first = "right",
  second = "top",
  change_line = FALSE,
  stringsAsFactors = TRUE
)
}
\arguments{
\item{x}{a vector of values to be paired with y.}

\item{y}{a vector of values to be paired with x.}

\item{first}{the first direction. It may be one of 
"right", "left", "top", "bottom". Default is "right".}

\item{second}{the second direction. It may be one of 
"right", "left", "top", "bottom". Default is "top".}

\item{change_line}{tail-to-tail or tail-to-head. Default 
is FALSE which means tail-to-tail. See examples.}

\item{stringsAsFactors}{to be passed to \code{data.frame}.}
}
\value{
always a 3-column data frame. Column x 
and y are coordinates of points; column index contains 
the index number of points.
}
\description{
This is a convenient function to generate points with
x and y coordinates (which form a 2-column data.frame).
It is much like \code{expand.grid}. The points generated 
by \code{expand.grid} always in this "s" order: the bottom 
line, form left to right, and the second line, from left to right.
However, \code{spathxy} allows you choose the order you 
want. See examples.
}
\examples{
library(ggplot2)
#
# dat1 is generated by expand.grid
# Note the difference between dat1 and dat2.
# dat3 is the same as dat1.
dat1=expand.grid(1: 3, 1: 7)
colnames(dat1)=c("x", "y")
dat2=spathxy(1: 3, 1: 7, 
	change_line=FALSE, first="right", second="top")
dat3=spathxy(1: 3, 1: 7, 
	change_line=TRUE, first="right", second="top")
#
mycolor=rainbow(nrow(dat1), end=0.6)
ggplot(dat1)+geom_path(aes(x, y), color=mycolor, size=3)
ggplot(dat2)+geom_path(aes(x, y), color=mycolor, size=3)
ggplot(dat3)+geom_path(aes(x, y), color=mycolor, size=3)
}
