% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/image_modify_rgb.R
\name{image_modify_rgb}
\alias{image_modify_rgb}
\title{Modify R, G, B Values of an Image}
\usage{
image_modify_rgb(
  x,
  set_r = NULL,
  add_r = NULL,
  mult_r = NULL,
  rescale_r = NULL,
  fun_r = NULL,
  set_g = NULL,
  add_g = NULL,
  mult_g = NULL,
  rescale_g = NULL,
  fun_g = NULL,
  set_b = NULL,
  add_b = NULL,
  mult_b = NULL,
  rescale_b = NULL,
  fun_b = NULL,
  alpha = FALSE,
  result = "magick",
  res = 144,
  checks = TRUE,
  warn = FALSE
)
}
\arguments{
\item{x}{an image created 
by \code{magick::image_read} or 
other functions in package magick.}

\item{set_r}{set r values with specific values.}

\item{add_r}{add specific 
values to current R values.}

\item{mult_r}{multiply the current values 
with specific values.}

\item{rescale_r}{a length 2 numeric vector 
specifying the desired range of R values, 
e. g., \code{rescale_r = c(180, 240)} which 
will make the smallest original value to 
be 180, and the largest, 240. Alternatively, 
it can be your own scaling function.}

\item{fun_r}{your own modifying function 
(e. g., \code{fun_r = sqrt}). Alternatively, it can 
be a list that designates how to use internal 
curves. See \code{\link{image_modify_hsv}}.}

\item{set_g, add_g, mult_g, rescale_g, fun_g}{parameters 
to change G values. Used in the same way as those 
for R. See above.}

\item{set_b, add_b, mult_b, rescale_b, fun_b}{parameters 
to change B values. Used in the same way as those 
for R. See above.}

\item{alpha}{whether to allow 
the output colors have transparency. Default is FALSE.}

\item{result}{the default is "magick", the output is 
a magick picture. When it is "raster", a matrix is created 
which can be use as a raster 
for \code{ggplot2::annotation_raster}.}

\item{res}{when the result is a magick picture, the 
\code{res} parameter used by \code{magick::image_graph}.
Default is 144.}

\item{checks}{when modifications are done, whether 
to check the output values. The default is TRUE which 
means whether the computed R, G and B values are 
in the [0, 255] range will be checked, and, those > 255 will 
be set to 255 and those < 0 will be set to 0 automatically. 
However, you can turn off these checks and (FALSE).}

\item{warn}{when \code{checks = TRUE}, whether 
to create a warning when values > 255 or < 0 are found 
and coerced to [0, 255].}
}
\description{
The function modifies the R, G, B values 
of an image and is used in the same 
way as \code{image_modify_hsv} 
in this package. The 
three channels can be modified separately.
The ways to modify include: setting values 
to some specified values (set_*), adding (add_*), 
multiplying the original values (mult_*), 
rescaling the original values (rescale_*), 
using a function to recompute values (fun_*). 
The most useful way is to use some internal 
curves that mimic those PS-like apps.
}
\details{
Several internal curves can be used. 
Please see the Details part 
of \code{\link{image_modify_hsv}}.
}
