% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plmm_format.R
\name{plmm_format}
\alias{plmm_format}
\title{PLMM format: a function to format the output of a model constructed with \code{plmm_fit}}
\usage{
plmm_format(fit, p, std_X_details, fbm_flag)
}
\arguments{
\item{fit}{A list of parameters describing the output of a model constructed with \code{plmm_fit}}

\item{p}{The number of features in the original data (including constant features)}

\item{std_X_details}{A list with 3 items:
\itemize{
\item 'center': the centering values for the columns of \code{X}
\item 'scale': the scaling values for the non-singular columns of \code{X}
\item 'ns': indicesof nonsingular columns in \code{std_X}
}}

\item{fbm_flag}{Logical: is the corresponding design matrix filebacked? Passed from \code{plmm()}.}
}
\value{
A list with the components:
\itemize{
\item \code{beta_vals}: the matrix of estimated coefficients on the original scale. Rows are predictors, columns are values of \code{lambda}
\item \code{lambda}: a numeric vector of the lasso tuning parameter values used in model fitting.
\item \code{eta}: a number (double) between 0 and 1 representing the estimated proportion of the variance in the outcome attributable to population/correlation structure.
\item \code{s}: a vectof of the eigenvalues of relatedness matrix \code{K}; see \code{relatedness_mat()} for details.
\item \code{U}: a matrix of the eigenvalues of relatedness matrix \code{K}
\item \code{rot_y}: the vector of outcome values on the rotated scale. This is the scale on which the model was fit.
\item \code{linear_predictors}: the matrix resulting from the product of \code{stdrot_X} and the estimated coefficients on the ~rotated~ scale.
\item \code{penalty}: character string indicating the penalty with which the model was fit (e.g., 'MCP')
\item \code{gamma}: numeric value indicating the tuning parameter used for the SCAD or lasso penalties was used. Not relevant for lasso models.
\item \code{alpha}: numeric value indicating the elastic net tuning parameter.
\item \code{loss}: vector with the numeric values of the loss at each value of \code{lambda} (calculated on the ~rotated~ scale)
\item \code{penalty_factor}: vector of indicators corresponding to each predictor, where 1 = predictor was penalized.
\item \code{ns_idx}: vector with the indices of predictors which were nonsingular features (i.e., had variation).
\item \code{iter}: numeric vector with the number of iterations needed in model fitting for each value of \code{lambda}
\item \code{converged}: vector of logical values indicating whether the model fitting converged at each value of \code{lambda}
}
}
\description{
PLMM format: a function to format the output of a model constructed with \code{plmm_fit}
}
\keyword{internal}
