% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tool_vcovG.R
\name{vcovDC}
\alias{vcovDC}
\alias{vcovDC.plm}
\title{Double-Clustering Robust Covariance Matrix Estimator}
\usage{
vcovDC(x, ...)

\method{vcovDC}{plm}(x, type = c("HC0", "sss", "HC1", "HC2", "HC3", "HC4"),
  ...)
}
\arguments{
\item{x}{an object of class \code{"plm"} or \code{"pcce"}}

\item{\dots}{further arguments}

\item{type}{the weighting scheme used, one of \code{"HC0"}, \code{"sss"},
\code{"HC1"}, \code{"HC2"}, \code{"HC3"}, \code{"HC4"}, see Details,}
}
\value{
An object of class \code{"matrix"} containing the estimate of
the covariance matrix of coefficients.
}
\description{
High-level convenience wrapper for double-clustering robust
covariance matrix estimators \emph{a la}
\insertCite{THOM:11;textual}{plm} and
\insertCite{CAME:GELB:MILL:11;textual}{plm} for panel models.
}
\details{
\code{vcovDC} is a function for estimating a robust covariance matrix of
parameters for a panel model with errors clustering along both dimensions.
The function is a convenience wrapper simply summing a group- and a
time-clustered covariance matrix and subtracting a diagonal one \emph{a la}
White.

Weighting schemes specified by \code{type} are analogous to those in
\code{\link[sandwich:vcovHC]{sandwich::vcovHC()}} in package \CRANpkg{sandwich} and are
justified theoretically (although in the context of the standard
linear model) by \insertCite{MACK:WHIT:85;textual}{plm} and
\insertCite{CRIB:04;textual}{plm} \insertCite{@see @ZEIL:04}{plm}.

The main use of \code{vcovDC} is to be an argument to other functions,
e.g.  for Wald-type testing: argument \code{vcov.} to \code{coeftest()},
argument \code{vcov} to \code{waldtest()} and other methods in the
\CRANpkg{lmtest} package; and argument \code{vcov.} to
\code{linearHypothesis()} in the \CRANpkg{car} package (see the
examples). Notice that the \code{vcov} and \code{vcov.} arguments allow to
supply a function (which is the safest) or a matrix
\insertCite{@see @ZEIL:04, 4.1-2 and examples below}{plm}.
}
\examples{

library(lmtest)
library(car)
data("Produc", package="plm")
zz <- plm(log(gsp)~log(pcap)+log(pc)+log(emp)+unemp, data=Produc, model="pooling")
## standard coefficient significance test
coeftest(zz)
## DC robust significance test, default
coeftest(zz, vcov.=vcovDC)
## idem with parameters, pass vcov as a function argument
coeftest(zz, vcov.=function(x) vcovDC(x, type="HC1", maxlag=4))
## joint restriction test
waldtest(zz, update(zz, .~.-log(emp)-unemp), vcov=vcovDC)
## test of hyp.: 2*log(pc)=log(emp)
linearHypothesis(zz, "2*log(pc)=log(emp)", vcov.=vcovDC)

}
\references{
\insertRef{CAME:GELB:MILL:11}{plm}

\insertRef{CRIB:04}{plm}

\insertRef{MACK:WHIT:85}{plm}

\insertRef{THOM:11}{plm}

\insertRef{ZEIL:04}{plm}
}
\seealso{
\code{\link[sandwich:vcovHC]{sandwich::vcovHC()}} from the \CRANpkg{sandwich}
package for weighting schemes (\code{type} argument).
}
\author{
Giovanni Millo
}
\keyword{regression}
