% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_imagem.R
\name{image_segment_kmeans}
\alias{image_segment_kmeans}
\title{Image segmentation using k-means clustering}
\usage{
image_segment_kmeans(
  img,
  bands = 1:3,
  nclasses = 2,
  invert = FALSE,
  opening = FALSE,
  closing = FALSE,
  filter = FALSE,
  erode = FALSE,
  dilate = FALSE,
  fill_hull = FALSE,
  plot = TRUE
)
}
\arguments{
\item{img}{An \code{Image} object.}

\item{bands}{A numeric integer/vector indicating the RGB band used in the
segmentation. Defaults to \code{1:3}, i.e., all the RGB bands are used.}

\item{nclasses}{The number of desired classes after image segmentation.}

\item{invert}{Invert the segmentation? Defaults to \code{FALSE}. If \code{TRUE} the
binary matrix is inverted.}

\item{erode, dilate, opening, closing, filter}{\strong{Morphological operations (brush size)}
\itemize{
\item \code{dilate} puts the mask over every background pixel, and sets it to
foreground if any of the pixels covered by the mask is from the foreground.
\item \code{erode} puts the mask over every foreground pixel, and sets it to
background if any of the pixels covered by the mask is from the background.
\item \code{opening} performs an erosion followed by a dilation. This helps to
remove small objects while preserving the shape and size of larger objects.
\item \code{closing} performs a dilatation followed by an erosion. This helps to
fill small holes while preserving the shape and size of larger objects.
\item \code{filter} performs median filtering in the binary image. Provide a positive
integer > 1 to indicate the size of the median filtering. Higher values are
more efficient to remove noise in the background but can dramatically impact
the perimeter of objects, mainly for irregular perimeters such as leaves
with serrated edges.
}

Hierarchically, the operations are performed as opening > closing > filter.
The value declared in each argument will define the brush size.}

\item{fill_hull}{Fill holes in the objects? Defaults to \code{FALSE}.}

\item{plot}{Plot the segmented image?}
}
\value{
A list with the following values:
\itemize{
\item \code{image} The segmented image considering only two classes (foreground and
background)
\item \code{clusters} The class of each pixel. For example, if \code{ncluster = 3},
\code{clusters} will be a two-way matrix with values ranging from 1 to 3.
\code{masks} A list with the binary matrices showing the segmentation.
}
}
\description{
Segments image objects using clustering by the k-means clustering algorithm
}
\examples{
if (interactive() && requireNamespace("EBImage")) {
img <- image_pliman("la_leaves.jpg", plot = TRUE)
seg <- image_segment_kmeans(img)
seg <- image_segment_kmeans(img, fill_hull = TRUE, invert = TRUE, filter = 10)
}
}
\references{
Hartigan, J. A. and Wong, M. A. (1979). Algorithm AS 136: A
K-means clustering algorithm. Applied Statistics, 28, 100–108.
\doi{10.2307/2346830}
}
