% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pleio_plot.R
\name{pleio_plot}
\alias{pleio_plot}
\title{Pleiotropic manhattan plot}
\usage{
pleio_plot(
  pleio_res,
  alpha = "bonferroni05",
  n_traits = 2,
  bp_positions = NULL,
  set_colors = NULL,
  set_text = NULL,
  set_plot = TRUE,
  chr_spacing = 1e+05,
  ...
)
}
\arguments{
\item{pleio_res}{object returned by pleio_test().}

\item{alpha}{numeric threshold for significance level (Bonferroni correction by default).}

\item{n_traits}{integer indicating the level of pleiotropy to test (a.k.a. number of traits).}

\item{bp_positions}{dataframe with colnames 'chr' and 'pos' indicating the chromosome and position for each SNP. Rownames must contain SNP names matching results of pleio_test.}

\item{set_colors}{string with 3 colors to use in the plot (by default: c('goldenrod4', 'brown4', 'royalblue2')).}

\item{set_text}{dataframe or matrix with strings to add as text to identify SNPs or genes. Rownames must be SNP names matching results of pleio_test. The first column of the dataframe must have strings to plot as text.}

\item{set_plot}{logical indicating whether to return the manhattan plot (TRUE by default).}

\item{chr_spacing}{integer indicating the spacing (in base pair positions) between chromosomes. 1e5 by default.}

\item{...}{additional graphic parameters for the plot.}
}
\value{
Manhattan plot and dataframe with information related to significant SNPs.
}
\description{
Plots the p-values that test the hypothesis of pleiotropic effects on n_traits. This function also returns a dataframe with information of the significant SNPs.
}
