% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/item_gpcm.R
\name{item.gpcm}
\alias{item.gpcm}
\title{Estimates item parameters of LMA with linear restrictions on category scores}
\usage{
item.gpcm(
  Master,
  item.log,
  Phi.mat,
  fitem,
  TraitByTrait,
  PersonByItem,
  npersons,
  nitems,
  ncat,
  nless,
  ntraits,
  Maxnphi,
  pq.mat,
  starting.sv,
  LambdaName
)
}
\arguments{
\item{Master}{Master data frame}

\item{item.log}{History over iterations of items' log likelihood and
estimates of lambda, and item parameters}

\item{Phi.mat}{Starting value of matrix of association parameters (optional)}

\item{fitem}{Formula for item regressions}

\item{TraitByTrait}{Trait adjacency matrix (same as inTraitAdj)}

\item{PersonByItem}{Same as inData}

\item{npersons}{Number of persons}

\item{nitems}{Number of items}

\item{ncat}{Number of categories per item}

\item{nless}{Number of unique lambdas and unique nus per item}

\item{ntraits}{Number of latent traits}

\item{Maxnphi}{Number of phi parameters to bet estimated (NULL for 1 dimensional)}

\item{pq.mat}{Used to compute rest-scores and totals}

\item{starting.sv}{Fixed category scores}

\item{LambdaName}{Lambda names for formula for items item regressions}
}
\value{
Master     	Master data frame with up-dated category scores for items

item.log   	Up-dated history array over iterations of the algorithm
                       of items' log likelihood and estimated lambda and
                       alpha parameters
}
\description{
This function is internal to the function 'fit.gpcm' and performs the item
regressions. It is a core function of the pseudo-likelihood algorithm for
items of the GPCM. The function calls function 'itemGPCM.data' to create
the data for input into 'mnlogit', which is use to fit a conditional
multinomial model for each item.  The up-dated scale values are put into
the Master data frame and the 'item.log' array.  It generally would not
run outside of 'fit.gpcm' or 'ple.lma'.
}
