% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/med_smooth.R
\name{b_score}
\alias{b_score}
\title{2 way median polish}
\usage{
b_score(data, well, plate)
}
\arguments{
\item{data}{numeric data, either a vector or dataframe column}

\item{well}{alpha-numeric wellIDs. e.g 'A01'}

\item{plate}{numeric, number of wells within a plate, either 96 or 384}
}
\description{
2 way median polish to remove plate effects such as row/column/edge effects.
Given a dataframe containing alpha-numeric wellIDs and numerical values,
this \code{b_score} will return a dataframe of the same structure after
a two-way median smooth.
}
\examples{
df <- data.frame(well = num_to_well(1:96),
                 vals = rnorm(96))

b_score(data = df$vals,
        well = df$well,
        plate = 96)
}
