% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gps_home.R
\name{get_home}
\alias{get_home}
\title{Predict which cluster is an individual's home.}
\usage{
get_home(
  df1,
  df2,
  home.start = "00:00:00",
  home.end = "06:00:00",
  filt = TRUE,
  max.distance = 150
)
}
\arguments{
\item{df1}{A dataframe of GPS coordinates as described below.}

\item{df2}{A dataframe with named clusters (most likely the dataframe that is returned after running \strong{reduce_multi} OR the places dataframe that is returned after running \strong{get_clusters}).}

\item{home.start}{A character vector HH:MM:SS which represents the start time that most individuals will be asleep by.}

\item{home.end}{A character vector HH:MM:SS which represent the start time that most individual may start to wake up by.}

\item{filt}{A logical T or F if the GPS data should be filtered between home.start and home.end. The default is T.}

\item{max.distance}{An integer in meters. It is the maximum distance in meters a cluster can be from the home location to be labelled as "home". The defaults is 150 m.}
}
\value{
Returns a list of dataframes. \strong{COUNT} is a dataframe that count how many times an individual was at a clusters  \strong{HOME} is a dataframe with clusters labelled as "Home", "Other", "In Transit"
}
\description{
Predict which cluster is an individual's home.
}
\section{Dataframe Requirements}{

The dataframe needs to have the following named columns:
\itemize{
  \item user_id = participant id
  \item lat = latitude coordinates
  \item lon = longitude coordinates
  \item start_time = GPS coordinates as POSIXct. Assumes POSIXct variable has been created using UTC timezone.
  \item tz_olson_id = local timezone (e.g., EST, America/New_York) as character vector.
}
}

\examples{
## Assume you have run get_clusters() on the dataset "places_gps"
\dontrun{

home <- get_home(places_gps, clusters[[1]], home.start = "21:30:00", home.end = "09:30:00")
}
}
\seealso{
\code{\link{get_clusters}} to cluster GPS coordinates into places.

\code{\link{get_places}} to label each cluster's place type as identified by Google Places API
}
