% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filecache.R
\name{remove_cached_files}
\alias{remove_cached_files}
\title{Delete all the given files from the package cache.}
\usage{
remove_cached_files(pkg_info, relative_filenames)
}
\arguments{
\item{pkg_info, }{named list. Package identifier, see get_pkg_info() on how to get one.}

\item{relative_filenames, }{vector of strings. A vector of filenames, relative to the package cache.}
}
\value{
logical vector. For each file, whether it was deleted. Note that files which did not exist were not deleted! You should check the results using `files_available`.
}
\description{
Delete all the given files from the package cache.
}
\examples{
    pkg_info = get_pkg_info("mypackage")
    deleted = remove_cached_files(pkg_info, "some_file.txt")

}
