% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sprinkle_fixed_header.R
\name{sprinkle_fixed_header}
\alias{sprinkle_fixed_header}
\alias{sprinkle_fixed_header.default}
\alias{sprinkle_fixed_header.dust_list}
\title{Assign a Fixed Header to an HTML Table}
\usage{
sprinkle_fixed_header(x, fixed_header = TRUE,
  include_fixed_header_css = TRUE, fixed_header_class_name = "pixie-fixed",
  scroll_body_height = 300, scroll_body_height_units = "px",
  scroll_body_background_color = "white", fixed_header_height = 20,
  fixed_header_height_units = "px",
  fixed_header_text_height = fixed_header_height/2,
  fixed_header_text_height_units = "px",
  fixed_header_background_color = "white", ...)

\method{sprinkle_fixed_header}{default}(x, fixed_header = TRUE,
  include_fixed_header_css = TRUE, fixed_header_class_name = "pixie-fixed",
  scroll_body_height = 300, scroll_body_height_units = "px",
  scroll_body_background_color = "white", fixed_header_height = 20,
  fixed_header_height_units = "px",
  fixed_header_text_height = fixed_header_height/2,
  fixed_header_text_height_units = "px",
  fixed_header_background_color = "white", ...)

\method{sprinkle_fixed_header}{dust_list}(x, fixed_header = TRUE,
  include_fixed_header_css = TRUE, fixed_header_class_name = "pixie-fixed",
  scroll_body_height = 300, scroll_body_height_units = "px",
  scroll_body_background_color = "white", fixed_header_height = 20,
  fixed_header_height_units = "px",
  fixed_header_text_height = fixed_header_height/2,
  fixed_header_text_height_units = "px",
  fixed_header_background_color = "white", ...)
}
\arguments{
\item{x}{An object of class \code{dust}}

\item{fixed_header}{\code{logical(1)}. When \code{TRUE}, HTML output will
produce a table with a fixed header and a scrollable body.}

\item{include_fixed_header_css}{\code{logical(1)}. When \code{TRUE}, the CSS code to
produce the table is inserted directly ahead of the HTML code for the
table.  When \code{FALSE}, the CSS is omitted and assumed to be provided
by the user.  This may be beneficial if the user has defined CSS styles
for their tables.  In this case, the user will need to add CSS classes
to their customized CSS to accomodate the fixed headers.  See Avoiding
CSS Conflicts.}

\item{fixed_header_class_name}{\code{character(1)}. When 
\code{include_fixed_header_css = FALSE}, this
class name is used to reference CSS classes provided by the user to
format the table correctly.}

\item{scroll_body_height}{\code{integerish(1)}. Sets the height of the scrollable
table body.}

\item{scroll_body_height_units}{\code{character(1)}. Determines the units for the
height of the scrollable table.  Defaults to \code{"px"}.  Must be one
of \code{c("px", "pt", "\%", "em")}.}

\item{scroll_body_background_color}{\code{character(1)}. The color of the background
of the body.  Must be a valid color.  It defaults to white, which may
override CSS settings provided by the user.  If this needs to be avoided,
you may use the \code{\link{fixed_header_css}} function to assist in
generating CSS code to use to define the CSS. See Avoiding CSS Conflicts.}

\item{fixed_header_height}{\code{integerish(1)}. Sets the height of the header
row.}

\item{fixed_header_height_units}{\code{character(1)}. Determines the units for the
height of the header row. Defaults to \code{"px"}. Must be one of
\code{c("px", "pt", "\%", "em")}.}

\item{fixed_header_text_height}{\code{numeric(1)}. Sets the height at which the
header text appears.  By default it is set to half of the header height.
This should be approximately centered, but you may alter this to get the
precise look you want.}

\item{fixed_header_text_height_units}{\code{character(1)}. Determines the units for
placing the header text.  Defaults to \code{"px"}. Must be one of
\code{c("px", "pt", "\%", "em")}.}

\item{fixed_header_background_color}{\code{character(1)}. Sets the background color for
the header row.  This defaults to white and may override the user's CSS
settings.  See Avoiding CSS Conflicts.}

\item{...}{Arguments to pass to other methods.}
}
\description{
Long tables to be displayed on-screen may benefit by keeping
  the header fixed in position while scrolling through the body of the
  table.  This allows the user to maintain visual contact between the
  column name and the data.
}
\details{
CSS doesn't make this kind of table natural.  The solution to 
  generate the fixed headers used by \code{pixiedust} is probably not the 
  best solution in terms of CSS design.  It is, however, the most conducive 
  to generating dynamically on the fly. 
  
  The fixed header table requires nesting several HTML elements. 
  \enumerate{
   \item a \code{div} tag is used to control the alignment of the table
   \item a \code{section} tag is used to set up the header row that remains fixed.
   \item a \code{div} that sets the height of the scrollable body
   \item the \code{table} tag establishes the actual table.
   \item The \code{th} tags inside the table are set to full transparency and
     the content of the headers is duplicated in a \code{div} within the 
     \code{th} tag to display the content.
  }
  
  To accomplish these tasks, some CSS is exported with the table and placed
  in the document immediately before the table.  Read further to understand
  the conflicts that may arise if you are using custom CSS specifications 
  in your documents.
}
\section{Avoiding CSS Conflicts}{
 
Because of all of the shenanigans involved, exporting the CSS with the tables
may result in conflicts with your custom CSS. Most importantly, any CSS
you have applied to the \code{th} or \code{td} tags may be overwritten.
If you are using custom CSS, you may want to consider using 
\code{include_fixed_header_css = FALSE} and then utilizing 
\code{\link{fixed_header_css}} to generate CSS you can include in your 
CSS file to provide the fixed headers.  The code generated by 
\code{fixed_header_css} ought to be placed before your definitions for
\code{td} and \code{th}.  

To get the same header design in the fixed table, you will want to modify 
the \code{.th-pixie-fixed div} definition in the CSS to match your desired
\code{th} definition.

The code produced by \code{fixed_header_css} will include comments where
there is potential for a CSS conflict.
}

\section{Functional Requirements}{

\enumerate{
 \item Set the \code{fixed_header} element of the \code{dust} object correctly.
 \item Set the \code{include_fixed_header_css} element of the \code{dust}
   object correctly.
 \item Set the \code{fixed_header_param} element of the \code{dust} object
   correctly.
 \item Cast an error if \code{x} does not inherit class \code{dust}
 \item Cast an error if \code{scroll_body_height} is not \code{integerish(1)}
 \item Cast an error if \code{scroll_body_height_units} is not \code{character(1)}
 \item Cast an error if \code{scroll_body_background_color} is not \code{character(1)}
 \item Cast an error if \code{scroll_body_background_color} is not a valid color.
 \item Cast an error if \code{fixed_header_height} is not \code{integerish(1)}
 \item Cast an error if \code{fixed_header_height_units} is not \code{character(1)}
 \item Cast an error if \code{fixed_header_text_height} is not \code{numeric(1)}
 \item Cast an error if \code{fixed_header_text_height_units} is not \code{character(1)}
 \item Cast an error if \code{fixed_header_background_color} is not \code{character(1)}
 \item Cast an error if \code{fixed_header_background_color} is not a valid color.
 \item Cast an error if \code{include_fixed_header_css} is not \code{logical(1)}
 \item Cast an error if \code{fixed_header_class_name} is not \code{character(1)}
}
}

