% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PivotFilter.R
\docType{class}
\name{PivotFilter}
\alias{PivotFilter}
\title{R6 class that defines a filter condition.}
\format{
\code{\link{R6Class}} object.
}
\description{
The `PivotFilter` class represents a single filter condition.
}
\details{
The filter condition represented by a `PivotFilter` instance relates to
one data frame variable/column and is of the form
[ColumnName] IN c(Value1, Value2, Value3, ...).
Often in a pivot table, each filter specifies only one data
value, as typically each distinct data value exists in a separate row or
column.
The `PivotFilter` class contains methods to perform set based operations
on filter values when combining filters.
}
\examples{
pt <- PivotTable$new()
# ...
PivotFilter$new(pt, variableName="Country", values="England")
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{variableName}}{The name of the column in the data frame that this filter
applies to.}

\item{\code{safeVariableName}}{The name of the column in the data frame that this filter
applies to,  surrounded by back-ticks if the name is not legal.}

\item{\code{type}}{Either "ALL", "VALUES" or "NONE".  "VALUES" is the most
common type and means the data is filtered to a subset of values.  "ALL" means
there is no filtering, i.e. all values match.  "NONE" means there can be no
matching values/data.}

\item{\code{values}}{The subset of values that this filter matches.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-PivotFilter-new}{\code{PivotFilter$new()}}
\item \href{#method-PivotFilter-intersect}{\code{PivotFilter$intersect()}}
\item \href{#method-PivotFilter-union}{\code{PivotFilter$union()}}
\item \href{#method-PivotFilter-replace}{\code{PivotFilter$replace()}}
\item \href{#method-PivotFilter-getCopy}{\code{PivotFilter$getCopy()}}
\item \href{#method-PivotFilter-asList}{\code{PivotFilter$asList()}}
\item \href{#method-PivotFilter-asJSON}{\code{PivotFilter$asJSON()}}
\item \href{#method-PivotFilter-asString}{\code{PivotFilter$asString()}}
\item \href{#method-PivotFilter-clone}{\code{PivotFilter$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PivotFilter-new"></a>}}
\if{latex}{\out{\hypertarget{method-PivotFilter-new}{}}}
\subsection{Method \code{new()}}{
Create a new `PivotFilter` object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PivotFilter$new(parentPivot, variableName = NULL, type = "ALL", values = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{parentPivot}}{The pivot table that this `PivotFilter`
instance belongs to.}

\item{\code{variableName}}{The name of the column in the data frame that this filter
applies to.}

\item{\code{type}}{Must be either "ALL", "VALUES" or "NONE".  "VALUES" is the most
common type and means the data is filtered to a subset of values.  "ALL" means
there is no filtering, i.e. all values match.  "NONE" means there can be no
matching values/data.}

\item{\code{values}}{A single data value or a vector of multiple data values that
this filter will match on.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new `PivotFilter` object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PivotFilter-intersect"></a>}}
\if{latex}{\out{\hypertarget{method-PivotFilter-intersect}{}}}
\subsection{Method \code{intersect()}}{
Updates this filter by intersecting the values in this filter with the
values from another `PivotFilter` object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PivotFilter$intersect(filter)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{filter}}{A `PivotFilter` object.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
No return value.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PivotFilter-union"></a>}}
\if{latex}{\out{\hypertarget{method-PivotFilter-union}{}}}
\subsection{Method \code{union()}}{
Updates this filter by unioning the values in this filter with the
values from another `PivotFilter` object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PivotFilter$union(filter)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{filter}}{A `PivotFilter` object.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
No return value.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PivotFilter-replace"></a>}}
\if{latex}{\out{\hypertarget{method-PivotFilter-replace}{}}}
\subsection{Method \code{replace()}}{
Updates this filter by replacing the values in this filter with the
values from another `PivotFilter` object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PivotFilter$replace(filter)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{filter}}{A `PivotFilter` object.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
No return value.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PivotFilter-getCopy"></a>}}
\if{latex}{\out{\hypertarget{method-PivotFilter-getCopy}{}}}
\subsection{Method \code{getCopy()}}{
Create a copy of this `PivotFilter` object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PivotFilter$getCopy()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A copy of this `PivotFilter` object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PivotFilter-asList"></a>}}
\if{latex}{\out{\hypertarget{method-PivotFilter-asList}{}}}
\subsection{Method \code{asList()}}{
Return the contents of this object as a list for debugging.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PivotFilter$asList()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A list of various object properties.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PivotFilter-asJSON"></a>}}
\if{latex}{\out{\hypertarget{method-PivotFilter-asJSON}{}}}
\subsection{Method \code{asJSON()}}{
Return the contents of this object as JSON for debugging.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PivotFilter$asJSON()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A JSON representation of various object properties.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PivotFilter-asString"></a>}}
\if{latex}{\out{\hypertarget{method-PivotFilter-asString}{}}}
\subsection{Method \code{asString()}}{
Return a representation of this object as a character value.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PivotFilter$asString(includeVariableName = TRUE, seperator = " ")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{includeVariableName}}{`TRUE` (default) to include the variable name in
the string.}

\item{\code{seperator}}{A character value used when concatenating
multiple filter values.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A character summary of various object properties.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PivotFilter-clone"></a>}}
\if{latex}{\out{\hypertarget{method-PivotFilter-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PivotFilter$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
