% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/twin_to_yule_tree.R
\name{sim_yule_twin_tree}
\alias{sim_yule_twin_tree}
\title{Create a twin tree from a phylogeny using a Yule process}
\usage{
sim_yule_twin_tree(
  true_phylogeny,
  method = "random_tree",
  n_replicates = 10000
)
}
\arguments{
\item{true_phylogeny}{the true phylogeny; the actual evolutionary
history of the species, of class \link[ape]{phylo}}

\item{method}{determines how to create the twin tree
\itemize{
    \item 'random_tree' just produces a random tree;
    \item 'max_clade_cred' simulates \code{n_replicates} trees and
      uses \link[phangorn]{maxCladeCred} to create a consensus tree;
    \item 'max_likelihood' simulates \code{n_replicates} trees
     and selects the most likely;
  }}

\item{n_replicates}{number of replicas to evaluate in order to create the
twin tree}
}
\value{
a twin Yule tree of class \link[ape]{phylo},
}
\description{
Create a twin tree from a phylogeny using a Yule process
}
\examples{
phylogeny <- ape::read.tree(text = "((A:2, B:2):1, C:3);")
yule_tree <- sim_yule_twin_tree(phylogeny)
}
\seealso{
Use \link{sim_bd_twin_tree} to simulate a Birth-Death twin tree.
Use \link{create_sim_yule_twin_tree_fun} to get a partially
evaluated function to use in the \code{twinning_params} (as
created by \link{create_twinning_params})
}
\author{
Richèl J.C. Bilderbeek, Giovanni Laudanno
}
