% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pir_rename.R
\name{pir_rename}
\alias{pir_rename}
\title{Rename the filenames in a \code{pir_params}
using a rename function.}
\usage{
pir_rename(pir_params, rename_fun)
}
\arguments{
\item{pir_params}{the parameters of \link[pirouette]{pirouette}.
They are created by \link{create_pir_params}.}

\item{rename_fun}{a function to rename a filename,
as can be checked by \link{check_rename_fun}. This function should
have one argument, which will be a filename or \link{NA}. The
function should \link{return} one filename (when passed one filename) or
one \link{NA} (when passed one \link{NA}).
Example rename functions are:
\itemize{
  \item \link{get_remove_dir_fun} function that removes the directory
    paths from the filenames, in effect turning these into local files
  \item \link{get_replace_dir_fun} function that replaces the directory
    paths from the filenames
}}
}
\value{
a `pir_params` with renamed filename
}
\description{
Rename the filenames in a \code{pir_params}
using a rename function.
}
\author{
Richèl J.C. Bilderbeek
}
