% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_bd_twin_tree.R
\name{sim_bd_twin_tree}
\alias{sim_bd_twin_tree}
\title{Simulate a Birth-Death (BD) twin tree from the true phylogeny}
\usage{
sim_bd_twin_tree(
  true_phylogeny,
  method = "random_tree",
  n_replicates = 10000,
  os = rappdirs::app_dir()$os
)
}
\arguments{
\item{true_phylogeny}{the true phylogeny; the actual evolutionary
history of the species, of class \link[ape]{phylo}}

\item{method}{determines how to create the twin tree
\itemize{
    \item 'random_tree' just produces a random tree;
    \item 'max_clade_cred' simulates \code{n_replicates} trees and
      uses \link[phangorn]{maxCladeCred} to create a consensus tree;
    \item 'max_likelihood' simulates \code{n_replicates} trees
     and selects the most likely;
  }}

\item{n_replicates}{number of replicas to evaluate in order to create the
twin tree}

\item{os}{name of the operating system, can be \code{mac}, \code{unix}
or \code{win}. Use \link[beastier]{check_os} if the operating system
is valid.}
}
\value{
a twin BD tree of class \link[ape]{phylo},
  obtained from the corresponding phylogeny.
}
\description{
Simulate a Birth-Death (BD) twin tree from the true phylogeny
}
\examples{
phylogeny <- ape::read.tree(text = "((A:2, B:2):1, C:3);")
sim_bd_twin_tree(phylogeny)
}
\seealso{
Use \link{sim_yule_twin_tree} to simulate a Yule twin tree
Use \link{get_sim_bd_twin_tree_fun} to get a partially
evaluated function to use in the \code{twinning_params} (as
created by \link{create_twinning_params})
}
\author{
Richèl J.C. Bilderbeek, Giovanni Laudanno
}
