% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aliases.R
\name{pipe_set_keep_out}
\alias{pipe_set_keep_out}
\title{Change output flag}
\usage{
pipe_set_keep_out(pip, step, keepOut = TRUE)
}
\arguments{
\item{pip}{\code{Pipeline} object}

\item{step}{\code{string} name of step}

\item{keepOut}{\code{logical} whether to keep output of step}
}
\value{
the \code{Pipeline} object invisibly
}
\description{
Change the \code{keepOut} flag at a given pipeline step,
which determines whether the output of that step is collected
when calling \code{\link[=pipe_collect_out]{pipe_collect_out()}}\verb{after the pipeline was run. See column}keepOut` when printing a pipeline to view the status.
}
\examples{
p <- pipe_new("pipe", data = 1)
pipe_add(p, "add1", \(x = ~data, y = 1) x + y, keepOut = TRUE)
pipe_add(p, "add2", \(x = ~data, y = 2) x + y)
pipe_add(p, "mult", \(x = ~add1, y = ~add2) x * y)
p |> pipe_run() |> pipe_collect_out()

pipe_set_keep_out(p, "add1", keepOut = FALSE)
pipe_set_keep_out(p, "mult", keepOut = TRUE)
p |> pipe_run() |> pipe_collect_out()
}
