% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aliases.R
\name{pipe_get_graph}
\alias{pipe_get_graph}
\title{Pipeline graph}
\usage{
pipe_get_graph(pip, groups = NULL)
}
\arguments{
\item{pip}{\code{Pipeline} object}

\item{groups}{\code{character} if not \code{NULL}, only steps belonging to the
given groups are considered.}
}
\value{
list with two data frames, one for nodes and one for edges
ready to be used with the \code{\link[visNetwork:visNetwork]{visNetwork::visNetwork()}} function of the
\link[visNetwork]{visNetwork} package.
}
\description{
Get the pipeline as a graph with nodes and edges.
}
\examples{
p <- pipe_new("pipe", data = 1:2)
pipe_add(p, "add1", \(data = ~data, x = 1) x + data)
pipe_add(p, "add2", \(x = 1, y = ~add1) x + y)
pipe_add(p, "mult1", \(x = ~add1, y = ~add2) x * y)
graph <- pipe_get_graph(p)
graph

if (require("visNetwork", quietly = TRUE)) {
    do.call(visNetwork, args = graph)
}
}
