% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aliases.R
\name{pipe_insert_after}
\alias{pipe_insert_after}
\alias{pipe_insert_before}
\title{Insert step}
\usage{
pipe_insert_after(pip, afterStep, step, ...)

pipe_insert_before(pip, beforeStep, step, ...)
}
\arguments{
\item{pip}{\code{Pipeline} object}

\item{afterStep}{\code{string} name of step after which to insert}

\item{step}{\code{string} name of step to insert}

\item{...}{further arguments passed to \code{\link[=pipe_add]{pipe_add()}}}

\item{beforeStep}{\code{string} name of step before which to insert}
}
\value{
returns the \code{Pipeline} object invisibly
}
\description{
Insert step
}
\section{Methods}{

\itemize{
\item \code{pipe_insert_after}: insert step after a certain step of the pipeline
\item \code{pipe_insert_before}: insert step before a certain step of the pipeline
}
}

\examples{
# pipe_insert_after
p <- pipe_new("pipe", data = 1)
pipe_add(p, "f1", \(x = 1) x)
pipe_add(p, "f2", \(x = ~f1) x)
pipe_insert_after(p, "f1", step = "after_f1", \(x = ~f1) x)
p

# insert_before
pipe_insert_before(p, "f2", step = "before_f2", \(x = ~f1) 2 * x)
p
}
