\name{pinktoe}
\alias{pinktoe}
\title{Pinktoe: convert S trees to web files for interactive traversal.}
\description{
	Pinktoe converts a S tree object to a set of HTML and perl files
	that can be, once uploaded to a perl-aware web server,
	interactively traversed by a user with a web browser. This is
	useful for large trees or trees where the variables require
	description by verbose text.
}
\usage{
pinktoe(treeobj, textfn, tittext, treeid = "",
    cgibindir = paste("/~magpn/cgi-bin/", treeid, "/", sep = ""),
    htmldir = paste("/home/magpn/public_html/Research/Politics/TREE/",
    treeid, "/", sep = ""), localdir = "Tree/", stateprintfn = partyprint,
    requirelib = "../party.lib", commonhtml)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{treeobj}{ An object of class rpart (or tree in S) }
  \item{textfn}{ A user supplied function that prints out text to a file in response to a variable name.}
  \item{tittext}{ A user supplied function that prints out title text to a
	file in response to a variable name }
  \item{treeid}{ This is a character string which is appended to both
	\code{cgibindir} and \code{htmldir}.
	This can be useful when you are building
	web pages for a collection of trees and store different trees in
	separate directories. }
  \item{cgibindir}{ A character string containing the directory where the perl
	files generated by pinktoe (with the extension \code{.pl}) will be
	stored.  
	(This should be the directory part of the URL of the cgi-bin 
	directory). }

  \item{htmldir}{ A character string containing the directory where the HTML
		files generated by pinktoe (with the extension \code{.htm})
		will be stored.  (This should be a pathname understood and
		able to be found by perl).
}
  \item{localdir}{A local location to store both the HTML and perl files
	immediately after they are generated }

  \item{stateprintfn}{A user-supplied function that decides what to do when
	supplied with the \code{yval} reached at the leaf of a tree. Some 
	text can be output, or maybe a perl function call.  }

  \item{requirelib}{A library of perl functions that can be called by, e.g.
	\code{stateprintfn}. The library that this refers to
	should reside in the \code{cgibin} directory. If no function calls
	are planned then it doesn't matter what argument is supplied.}

  \item{commonhtml}{A user-supplied function that prints out some HTML code.
	This is appended to every HTML web page.}
}
\details{
	See the example below for usage. See
\url{http://www.stats.bris.ac.uk/~magpn/Research/Pinktoe/Welcome.html}
for a full description
}
\value{ No value is produced.  }
\references{ 
\url{http://www.stats.bris.ac.uk/~magpn/Research/Pinktoe/Welcome.html}
}
\author{Guy P Nason}
\note{ This is version 2, an earlier version didn't work well with R}

\seealso{ \code{\link{PT}}}
\examples{
#
# Attach rpart library
#
library("rpart")
data("mpincdf99")
#
# Create a tree (rpart object)
#
z.edm <- makeEDMtree()
#
# Plot the tree to see its basic structure.
#
plot(z.edm)
text(z.edm)
#
# Now use pinktoe to generate a set of htm and pl files that can be used
# by a CGI-enabled web server to traverse the tree.
#
data("edmbigtext")
#
# Next code requires "sfsmisc" library. This is not installed by default
# in R distributions so you'll have to get it yourself. We make sure
# that the next code doesn't run because R CMD check can't install packages (I think)
#
\dontrun{pinktoe(z.edm, edm.text, partytittext, treeid="", localdir="./",
    cgibindir="/~magpn/cgi-bin/TEST/",  
    htmldir="/home/magpn/public_html/TEST/", stateprintfn=partyprint, 
    requirelib="../party.lib", 
    commonhtml=partycommonhtml)  }
# Frame row number is  1 
# Node number is  1 
# Frame row number is  2 
# Node number is  2 
# Frame row number is  3 
# Node number is  4 
# Frame row number is  4 
# Node number is  8 
# Frame row number is  6 
# Node number is  17 
# Frame row number is  7 
# Node number is  34 
# Frame row number is  8 
# Node number is  68 
# Frame row number is  9 
# Node number is  136 
# Frame row number is  17 
# Node number is  3 
#
# If you look in the current directory you'll find a load of perl and
# HTML files created.
#
}
\keyword{ iplot }
\keyword{ tree }
