% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sandwich.estimator.R
\name{sandwich.estimator}
\alias{sandwich.estimator}
\alias{score.estimator}
\title{Pseudo-observation variance sandwich estimator}
\usage{
sandwich.estimator(U, U.diff, g1, g2, shared.factor = 1,
  switched.factor = 1, self.factor = 1)
}
\arguments{
\item{U}{See the formula for sandwich estimator: 
holds \code{U_{ij}}}

\item{U.diff}{See the formula for sandwich estimator: 
holds the partial derivatives of \code{U}.}

\item{g1, g2}{Index in the original observations of the "left" and "right" part of the pseudo-observations.}

\item{shared.factor}{Factor by which all \code{UijUik} or
\code{UijUlj} will be multiplied}

\item{switched.factor}{Factor by which all \code{UijUki} or
\code{UijUjl} will be multiplied}

\item{self.factor}{Factor by which all \code{UijUij} or 
\code{-UijUji} will be multiplied}
}
\value{
The matrix of the sandwich estimator
}
\description{
The functions described here all implement an estimator for
the variance of the coefficients. This function is not exported.
}
