% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/new.pim.formula.R
\docType{methods}
\name{new.pim.formula}
\alias{new.pim.formula}
\alias{new.pim.formula,formula,ANY-method}
\alias{new.pim.formula,formula,pim.environment-method}
\title{Constructor for pim.formula}
\usage{
new.pim.formula(formula, data, ...)

\S4method{new.pim.formula}{formula,pim.environment}(formula, data, ...)

\S4method{new.pim.formula}{formula,ANY}(formula, data, ...)
}
\arguments{
\item{formula}{a formula object}

\item{data}{either a \code{\link{pim.environment}} object containing the
data for the pim, or an object that can be converted to a 
\code{pim.environment} by \code{\link{new.pim.env}}}

\item{...}{extra arguments to \code{\link{new.pim.env}}}
}
\value{
a \code{\link{pim.formula}} object.
}
\description{
This function reworks a formula to a pim.formula for use
in a probabilistic index model. This function is only meant
to be used internally, but is exported. It should be used only
in concordance with \code{\link{model.matrix.pim}}
}
\details{
It is the constructor to be used for a \code{\link{pim.formula}}
object, and should only be used in conjunction with 
\code{\link{model.matrix.pim}} and \code{\link{pim.fit}} as shown
in the examples.
}
\seealso{
\code{\link{pim.formula-class}} for more information on the 
class itself. \code{\link{PO}}, \code{\link{L}} and \code{R} for some
functions that can be used in a \code{pim.formula}

#' @examples 
data("FEVData")
# Create the "model frame"
FEVenv <- new.pim.env(FEVData, compare="unique")
# This includes the poset
pos <- poset(FEVenv, as.list=TRUE)

# create the formula and bind it to the pim.environment.
FEVform <- new.pim.formula(
  Age ~ I(L(Height) - R(Height))  ,
  FEVenv
)

# Use this formula object to construct the model matrix
# use the default model ( difference )
MM <- model.matrix(FEVform)

# Use this formula object to construct the pseudo response
Y <- response(FEVform)

# Now pim.fit can do what it does
res <- pim.fit(MM,Y, estim = "estimator.glm", penv=FEVenv)
}

