% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pb_info.R
\name{pb_releases}
\alias{pb_releases}
\title{List releases in repository}
\usage{
pb_releases(
  repo = guess_repo(),
  .token = gh::gh_token(),
  verbose = getOption("piggyback.verbose", default = TRUE)
)
}
\arguments{
\item{repo}{GitHub repository specification in the form of \code{"owner/repo"}, if not specified will try to guess repo based on current working directory.}

\item{.token}{a GitHub API token, defaults to \code{gh::gh_token()}}

\item{verbose}{defaults to TRUE, use FALSE to silence messages}
}
\value{
a dataframe of all releases available within a repository.
}
\description{
This function retrieves information about all releases attached to a given repository.
}
\examples{
\donttest{
try({ # wrapped in try block to prevent CRAN errors
 pb_releases("nflverse/nflverse-data")
})
}
}
