% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_piece.R
\name{scale_x_piece}
\alias{scale_x_piece}
\alias{scale_y_piece}
\alias{label_letter}
\alias{label_counting}
\alias{breaks_counting}
\title{ggplot2 game diagram scales}
\usage{
scale_x_piece(
  ...,
  name = NULL,
  breaks = breaks_counting(),
  minor_breaks = NULL,
  labels = label_letter()
)

scale_y_piece(
  ...,
  name = NULL,
  breaks = breaks_counting(),
  minor_breaks = NULL,
  labels = label_counting()
)

label_letter()

label_counting()

breaks_counting()
}
\arguments{
\item{...}{Passed to \code{\link[ggplot2:scale_continuous]{ggplot2::scale_x_continuous()}} or \code{\link[ggplot2:scale_continuous]{ggplot2::scale_y_continuous()}}.}

\item{name}{The name of the scale. Used as the axis or legend title. If
\code{waiver()}, the default, the name of the scale is taken from the first
mapping used for that aesthetic. If \code{NULL}, the legend title will be
omitted.}

\item{breaks}{One of:
\itemize{
\item \code{NULL} for no breaks
\item \code{waiver()} for the default breaks computed by the
\link[scales:new_transform]{transformation object}
\item A numeric vector of positions
\item A function that takes the limits as input and returns breaks
as output (e.g., a function returned by \code{\link[scales:breaks_extended]{scales::extended_breaks()}}).
Note that for position scales, limits are provided after scale expansion.
Also accepts rlang \link[rlang:as_function]{lambda} function notation.
}}

\item{minor_breaks}{One of:
\itemize{
\item \code{NULL} for no minor breaks
\item \code{waiver()} for the default breaks (one minor break between
each major break)
\item A numeric vector of positions
\item A function that given the limits returns a vector of minor breaks. Also
accepts rlang \link[rlang:as_function]{lambda} function notation. When
the function has two arguments, it will be given the limits and major
breaks.
}}

\item{labels}{One of:
\itemize{
\item \code{NULL} for no labels
\item \code{waiver()} for the default labels computed by the
transformation object
\item A character vector giving labels (must be same length as \code{breaks})
\item An expression vector (must be the same length as breaks). See ?plotmath for details.
\item A function that takes the breaks as input and returns labels
as output. Also accepts rlang \link[rlang:as_function]{lambda} function
notation.
}}
}
\value{
\code{scale_x_piece()} and \code{scale_y_piece()} return ggplot2 scale objects.
\code{label_letter()} and \code{label_counting()} return functions suitable for use with the \code{labels} scale argument.
\code{breaks_counting()} returns a function suitable for use with the \code{breaks} scale argument.
}
\description{
\code{scale_x_piece()} and \code{scale_y_piece()} are wrappers
around \code{\link[ggplot2:scale_continuous]{ggplot2::scale_x_continuous()}} and
\code{\link[ggplot2:scale_continuous]{ggplot2::scale_y_continuous()}} with "better"
defaults for board game diagrams.
\code{label_letter()} labels breaks with letters
and \code{label_counting()} labels breaks with positive integers
to more easily generate (i.e. chess) algebraic notation coordinates.
\code{breaks_counting()} generates breaks of just the positive integers within the limits.
}
\examples{
if (require("ggplot2", quietly = TRUE) && require("tibble", quietly = TRUE)) {
  envir <- game_systems("sans")
  df_board <- tibble(piece_side = "board_face", suit = 3, rank = 8,
                 x = 4.5, y = 4.5)
  df_w <- tibble(piece_side = "bit_back", suit = 6, rank = 1,
                 x = rep(1:8, 2), y = rep(1:2, each=8))
  df_b <- tibble(piece_side = "bit_back", suit = 1, rank = 1,
                 x = rep(1:8, 2), y = rep(7:8, each=8))
  df <- rbind(df_board, df_w, df_b)

  # `cfg` must be a character vector for `geom_piece()`
  ggplot(df, aes_piece(df)) +
      geom_piece(cfg = "checkers1", envir = envir) +
      coord_fixed() +
      scale_x_piece() +
      scale_y_piece() +
      theme_minimal(28) +
      theme(panel.grid = element_blank())
}
}
