% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pcd.R
\name{pcd}
\alias{pcd}
\title{pairwise site phylogenetic community dissimilarity (PCD) within a community}
\usage{
pcd(comm, tree, expectation = NULL, cpp = TRUE, verbose = TRUE, ...)
}
\arguments{
\item{comm}{A site by species data frame or matrix, sites as rows.}

\item{tree}{A phylogeny for species.}

\item{expectation}{nsp_pool, psv_bar, psv_pool, and nsr calculated from \code{pcd_pred()}.}

\item{cpp}{Whether to use loops written with c++, default is TRUE.}

\item{verbose}{Do you want to see the progress?}

\item{...}{Other arguments.}
}
\value{
A list of a variety of pairwise dissimilarities.
}
\description{
Calculate pairwise site PCD, users can specify expected values from \code{pcd_pred()}.
}
\examples{
x1 = pcd_pred(comm_1 = comm_a, comm_2 = comm_b, tree = phylotree, reps = 100)
pcd(comm = comm_a, tree = phylotree, expectation = x1)
}
\references{
Ives, A. R., & Helmus, M. R. 2010. Phylogenetic metrics of community similarity.
The American Naturalist, 176(5), E128-E142.
}
