% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/user-get.R
\name{get_tx_slot}
\alias{get_tx_slot}
\title{Get slot data for each taxon record}
\usage{
get_tx_slot(phylota, txid, slt_nm = list_taxrec_slots())
}
\arguments{
\item{phylota}{Phylota object}

\item{txid}{Taxonomic ID}

\item{slt_nm}{Slot name}
}
\value{
vector or list
}
\description{
Get slot data for taxa(s)
}
\examples{
data('aotus')
random_txid <- sample(aotus@txids, 1)
(get_tx_slot(phylota = aotus, txid = random_txid, slt_nm = 'scnm'))
# see list_taxrec_slots() for available slots
(list_taxrec_slots())
}
\seealso{
Other tools-public: \code{\link{calc_mad}},
  \code{\link{calc_wrdfrq}}, \code{\link{drop_by_rank}},
  \code{\link{drop_clstrs}}, \code{\link{drop_sqs}},
  \code{\link{get_clstr_slot}}, \code{\link{get_nsqs}},
  \code{\link{get_ntaxa}}, \code{\link{get_sq_slot}},
  \code{\link{get_stage_times}}, \code{\link{get_txids}},
  \code{\link{is_txid_in_clstr}},
  \code{\link{is_txid_in_sq}},
  \code{\link{list_clstrrec_slots}},
  \code{\link{list_ncbi_ranks}},
  \code{\link{list_seqrec_slots}},
  \code{\link{list_taxrec_slots}},
  \code{\link{plot_phylota_pa}},
  \code{\link{plot_phylota_treemap}},
  \code{\link{read_phylota}}, \code{\link{write_sqs}}
}
