\name{K.mult}
\alias{K.mult}
\title{
Test phylogenetic signal (Kmult) using phylogenetic simulation
}
\description{
An implementation of Kmult (Blomberg et al. 2003; Adams 2014) in which Kmult is compared to the null distribution generated by simulation on a star phylogeny (rather than phylogenetic permutation). Additionally, the expectation of the ratio of raw to phylogenetic mean squared error (the denominator of the formula for K) is estimated via phylogenetic simulation under Brownian motion.
}
\usage{
K.mult(model, nsim = 1000, plot = TRUE)
}
\arguments{
  \item{model}{
An object of class \code{evo.model}.
}
  \item{nsim}{
The number of iterations for phylogenetic simulation.
}
  \item{plot}{
Whether or not to plot the null and alternative distribution of Kmult.
}
}
\value{
An object of class \code{compare.model}.
}
\references{
Golsby E.W. 2015. Likelihood-based parameter estimation for high-dimensional phylogenetic comparative models: overcoming the limitations of 'distance-based' methods. In review.

Adams D.C. 2014. A generalized K statistic for estimating phylogenetic signal from shape and other high-dimensional multivariate data. Syst. Biol. 63:685-697.
}
\author{
Eric W. Goolsby
}
\seealso{
\code{\link[phylocurve]{evo.model}}
\code{\link[phylocurve]{compare.models}}
\code{\link[geomorph]{physignal}}
}
\examples{
rand.data <- sim.traits()
null.model <- evo.model(tree = rand.data$tree,
  Y = rand.data$trait_data,method = "Pairwise ML")

K.mult(model = null.model,nsim = 100)
}
