% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rao.R
\name{ph_rao}
\alias{ph_rao}
\title{rao - Rao's quadratic entropy}
\usage{
ph_rao(sample, phylo)
}
\arguments{
\item{sample}{(data.frame/character) sample data.frame or path to a
sample file}

\item{phylo}{(character/phylo) One of: phylogeny as a newick string (will be
written to a temp file) - OR path to file with a newick
string - OR a an \pkg{ape} \code{phylo} object. required.}
}
\value{
A list of 6 data.frame's:
\strong{Diversity components}:
\itemize{
\item overall alpha (within-site)
\item beta (among-site)
\item total diversity
\item Fst statistic of differentiation for diversity and phylogenetic
diversity
}

\strong{Within-community diversity}:
\itemize{
\item Plot - Plot name
\item NSpp - Number of species
\item NIndiv - Number of individuals
\item PropIndiv - Proportion of all individuals found in this plot
\item D - Diversity (= Simpson’s diversity)
\item Dp - Phylogenetic diversity (= Diversity weighted by interspecific
phylogenetic distances)
}

The remaining 4 tables compare each community pairwise:
\itemize{
\item among_community_diversity_d - Among-community diversities
\item among_community_diversity_h - Among-community diversities excluding
within-community diversity
\item among_community_phylogenetic_diversity_dp - Among-community
phylogenetic diversities
\item among_community_phylogenetic_diversity_hp - Among-community
phylogenetic diversities excluding within-community diversity
}
}
\description{
A measure of within- and among-community diversity taking species
dissimilarity (phylogenetic dissimilarity) into account
}
\examples{
sfile <- system.file("examples/sample_comstruct", package = "phylocomr")
pfile <- system.file("examples/phylo_comstruct", package = "phylocomr")

# sample from data.frame, phylogeny from a string
sampledf <- read.table(sfile, header = FALSE,
  stringsAsFactors = FALSE)
phylo_str <- readLines(pfile)

ph_rao(sample = sampledf, phylo = phylo_str)

# both from files
sample_str <- paste0(readLines(sfile), collapse = "\\n")
sfile2 <- tempfile()
cat(sample_str, file = sfile2, sep = '\\n')
pfile2 <- tempfile()
phylo_str <- readLines(pfile)
cat(phylo_str, file = pfile2, sep = '\\n')

ph_rao(sample = sfile2, phylo = pfile2)
}
\seealso{
Other phylogenetic-diversity: \code{\link{ph_pd}}
}
\concept{phylogenetic-diversity}
