% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comtrait.R
\name{ph_comtrait}
\alias{ph_comtrait}
\title{comtrait}
\usage{
ph_comtrait(sample, traits, binary = NULL, metric = "variance",
  null_model = 0, randomizations = 999, abundance = TRUE)
}
\arguments{
\item{sample}{(data.frame/character) sample data.frame or path to a
sample file}

\item{traits}{(data.frame/character) traits data.frame or path to a
traits file}

\item{binary}{(logical) a logical vector indicating what columns are to
be treated as binary characters - all others are treated as continuous}

\item{metric}{(integer) metric to calculate. One of variance, mpd, mntd,
or range (converted to phylocom integer format internally)}

\item{null_model}{(integer) which null model to use. See Details.}

\item{randomizations}{(numeric) number of randomizations. Default: 999}

\item{abundance}{(logical) If \code{TRUE} (default) computed accounting
for abundance. Otherwise, uses presence-absence.}
}
\value{
data.frame of the form:
\itemize{
\item trait - Trait name
\item sample - Sample name
\item ntaxa - Number of taxa in sample
\item mean - Mean value of trait in sample
\item metric - Observed metric in sample
\item meanrndmetric - Mean value of metric in null models
\item sdrndmetric - Standard deviation of metric in null models
\item sesmetric - Standardized effect size of metric
\item ranklow - Number of randomizations with metric lower than observed
\item rankhigh - Number of randomizations with metric higher than observed
\item runs - Number of randomizations
}
}
\description{
Calculate measures of trait dispersion within each community, and
compare observed patterns to those expected under a null model.
}
\details{
If you give a data.frame to \code{traits} parameter it expects data.frame like
\itemize{
\item species - the taxon labels matching the sample data to \code{sample}
parameter
\item col1,col2,col3,etc. - any number of trait columns - column names do
not matter
}

When giving a data.frame to \code{traits} make sure to pass in a binary
vector for what traits are to be treated as binary.
}
\section{Null models}{

\itemize{
\item 0 - This null model shuffles trait values across species.
\item 1 - Species in each sample become random draws from sample pool.
This null model maintains the species richness of each sample, but
the identities of the species occurring in each sample are randomized.
For each sample, species are drawn without replacement from the list of
all species actually occurring in at least one sample
\item 2 - Species in each sample become random draws from traits data.
This null model maintains the species richness of each sample, but the
identities of the species occurring in each sample are randomized. For
each sample, species are drawn without replacement from the list of all
species with trait values. This function is redundant since by definition
the sample and trait species must match, but is included for consistency
with the comstruct function.
\item 3 - Independent swap: Same as for \link{ph_comdist} and
\link{ph_comstruct}
}
}

\examples{
\dontrun{
sfile <- system.file("examples/sample_comstruct", package = "phylocomr")
tfile <- system.file("examples/traits_aot", package = "phylocomr")

# from files
sample_str <- paste0(readLines(sfile), collapse = "\\n")
sfile2 <- tempfile()
cat(sample_str, file = sfile2, sep = '\\n')

traits_str <- paste0(readLines(tfile), collapse = "\\n")
tfile2 <- tempfile()
cat(traits_str, file = tfile2, sep = '\\n')

ph_comtrait(sample = sfile2, traits = tfile2)

# from data.frame
sampledf <- read.table(sfile, header = FALSE,
  stringsAsFactors = FALSE)
traitsdf_file <- system.file("examples/traits_aot_df",
  package = "phylocomr")
traitsdf <- read.table(text = readLines(traitsdf_file), header = TRUE,
  stringsAsFactors = FALSE)
ph_comtrait(sample = sampledf, traits = traitsdf,
  binary = c(FALSE, FALSE, FALSE, TRUE))
}
}
